/*
 * Decompiled with CFR 0.152.
 */
package io.github.vinogradoff.testdatabroker.client;

import io.github.vinogradoff.testdatabroker.client.TestDataBrokerClient;
import io.github.vinogradoff.testdatabroker.exception.NotFoundException;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DefaultTestDataBrokerClient
implements TestDataBrokerClient {
    OkHttpClient client = new OkHttpClient();
    String baseUrl;

    public DefaultTestDataBrokerClient() {
        this.baseUrl = "http://localhost:8080";
    }

    public DefaultTestDataBrokerClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void writeData(String dictionary, String key, String value) throws IOException {
        RequestBody body = RequestBody.create(null, (byte[])new byte[0]);
        Request req = new Request.Builder().url(this.baseUrl + "/api/write/" + dictionary + "/" + key + "?value=" + value).post(body).build();
        this.client.newCall(req).execute();
    }

    @Override
    public String readData(String dictionary, String key) throws IOException {
        Request req = new Request.Builder().url(this.baseUrl + "/api/read/" + dictionary + "/" + key).build();
        Response resp = this.client.newCall(req).execute();
        if (resp.code() != 200 && resp.code() != 204) {
            throw new NotFoundException("Code:" + resp.code() + " Message:" + resp.body().string());
        }
        return resp.body().string();
    }

    @Override
    public void clearData(String dictionary, String key) throws IOException {
        RequestBody body = RequestBody.create(null, (byte[])new byte[0]);
        Request req = new Request.Builder().url(this.baseUrl + "/api/clear/" + dictionary + "/" + key).put(body).build();
        Response resp = this.client.newCall(req).execute();
        if (resp.code() != 200 && resp.code() != 204) {
            throw new NotFoundException("Code:" + resp.code() + " Message:" + resp.body().string());
        }
    }

    @Override
    public void deleteKey(String dictionary, String key) throws IOException {
        Request req = new Request.Builder().url(this.baseUrl + "/api/delete/" + dictionary + "/" + key).delete().build();
        Response resp = this.client.newCall(req).execute();
        if (resp.code() != 200 && resp.code() != 204) {
            throw new NotFoundException("Code:" + resp.code() + " Message:" + resp.body().string());
        }
    }

    @Override
    public void deleteDictionary(String dictionary) throws IOException {
        Request req = new Request.Builder().url(this.baseUrl + "/api/delete/" + dictionary).delete().build();
        Response resp = this.client.newCall(req).execute();
        if (resp.code() != 200 && resp.code() != 204) {
            throw new NotFoundException("Code:" + resp.code() + " Message:" + resp.body().string());
        }
    }

    @Override
    public String claimData(String dictionary, String key) throws IOException {
        RequestBody body = RequestBody.create(null, (byte[])new byte[0]);
        Request req = new Request.Builder().url(this.baseUrl + "/api/claim/" + dictionary + "/" + key).put(body).build();
        Response resp = this.client.newCall(req).execute();
        if (resp.code() != 200 && resp.code() != 204) {
            throw new NotFoundException("Code:" + resp.code() + " Message:" + resp.body().string());
        }
        return resp.body().string();
    }
}

