/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.model.ClaimsQuery;
import io.github.wistefan.dcql.model.credential.Disclosure;
import io.github.wistefan.dcql.model.credential.JwtCredential;
import io.github.wistefan.dcql.model.credential.LdpCredential;
import io.github.wistefan.dcql.model.credential.MDocCredential;
import io.github.wistefan.dcql.model.credential.SdJwtCredential;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimsEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ClaimsEvaluator.class);
    private static final String SD_KEY = "_sd";

    public static Optional<MDocCredential> evaluateClaimsForMDocCredential(ClaimsQuery claimsQuery, MDocCredential credential) {
        List<Object> selectedClaims = new ArrayList();
        try {
            selectedClaims = ClaimsEvaluator.selectClaimsByPath(credential.getPayload(), claimsQuery.getPath());
        }
        catch (IllegalArgumentException iae) {
            log.debug("Did not find the requested claims.", (Throwable)iae);
            return Optional.empty();
        }
        if (claimsQuery.getValues() == null || claimsQuery.getValues().isEmpty()) {
            return Optional.of(credential);
        }
        if (selectedClaims.stream().allMatch(sC -> claimsQuery.getValues().contains(sC.value()))) {
            return Optional.of(credential);
        }
        return Optional.empty();
    }

    public static Optional<SdJwtCredential> evaluateClaimsForSdJwtCredential(ClaimsQuery claimsQuery, SdJwtCredential credential) {
        ArrayList<SelectedClaim> selectedClaims = new ArrayList();
        try {
            selectedClaims = ClaimsEvaluator.selectClaimsByPathDisclosures(credential.getJwtCredential().getPayload(), claimsQuery.getPath(), credential.getDisclosures());
        }
        catch (IllegalArgumentException iae) {
            log.debug("Did not find the requested claims.", (Throwable)iae);
            return Optional.empty();
        }
        if (claimsQuery.getValues() == null || claimsQuery.getValues().isEmpty()) {
            return Optional.of(ClaimsEvaluator.cleanUpDisclosures(selectedClaims, credential));
        }
        if (selectedClaims.stream().allMatch(sC -> claimsQuery.getValues().contains(sC.value()))) {
            return Optional.of(ClaimsEvaluator.cleanUpDisclosures(selectedClaims, credential));
        }
        return Optional.empty();
    }

    private static SdJwtCredential cleanUpDisclosures(List<SelectedClaim> selectedClaims, SdJwtCredential credential) {
        Set hashsToInclude = selectedClaims.stream().map(SelectedClaim::hash).collect(Collectors.toSet());
        List<Disclosure> cleanedDisclosures = credential.getDisclosures().stream().filter(disclosure -> hashsToInclude.contains(disclosure.getSdHash())).toList();
        return new SdJwtCredential(credential.getRaw(), credential.getJwtCredential(), cleanedDisclosures);
    }

    public static Optional<JwtCredential> evaluateClaimsForJwtCredential(ClaimsQuery claimsQuery, JwtCredential credential) {
        List<Object> selectedClaims = new ArrayList();
        try {
            selectedClaims = ClaimsEvaluator.selectClaimsByPath(credential.getPayload(), claimsQuery.getPath());
        }
        catch (IllegalArgumentException iae) {
            log.debug("Did not find the requested claims.", (Throwable)iae);
            return Optional.empty();
        }
        if (claimsQuery.getValues() == null || claimsQuery.getValues().isEmpty()) {
            return Optional.of(credential);
        }
        if (selectedClaims.stream().allMatch(sC -> claimsQuery.getValues().contains(sC.value()))) {
            return Optional.of(credential);
        }
        return Optional.empty();
    }

    public static Optional<LdpCredential> evaluateClaimsForLdpCredential(ClaimsQuery claimsQuery, LdpCredential credential) {
        List<Object> selectedClaims = new ArrayList();
        try {
            selectedClaims = ClaimsEvaluator.selectClaimsByPath(credential.getTheCredential(), claimsQuery.getPath());
        }
        catch (IllegalArgumentException iae) {
            log.debug("Did not find the requested claims.", (Throwable)iae);
            return Optional.empty();
        }
        if (claimsQuery.getValues() == null || claimsQuery.getValues().isEmpty()) {
            return Optional.of(credential);
        }
        if (selectedClaims.stream().allMatch(sC -> claimsQuery.getValues().contains(sC.value()))) {
            return Optional.of(credential);
        }
        return Optional.empty();
    }

    private static List<SelectedClaim> selectClaimsByPath(Map<String, Object> credential, List<Object> claimPath) {
        return ClaimsEvaluator.processPath(credential, claimPath, null);
    }

    private static List<SelectedClaim> selectClaimsByPathDisclosures(Map<String, Object> credential, List<Object> claimPath, List<Disclosure> disclosures) {
        return ClaimsEvaluator.processPath(credential, claimPath, disclosures);
    }

    private static List<SelectedClaim> processPath(Map<String, Object> credential, List<Object> claimPath, List<Disclosure> disclosures) {
        if (credential == null || claimPath == null || claimPath.isEmpty()) {
            throw new IllegalArgumentException("Credential and claimPath must not be null or empty");
        }
        ArrayList<SelectedClaim> current = new ArrayList<SelectedClaim>();
        current.add(new SelectedClaim(credential, null));
        for (Object component : claimPath) {
            ArrayList<SelectedClaim> nextSelection = new ArrayList<SelectedClaim>();
            for (SelectedClaim candidateWrapper : current) {
                Integer index;
                List list;
                SelectedClaim sc;
                Iterator<Object> val;
                Map mapCandidate;
                LinkedHashMap<String, SelectedClaim> candidate = candidateWrapper.value;
                if (disclosures != null && candidate instanceof Map && (mapCandidate = (Map)candidate).containsKey(SD_KEY)) {
                    Object sdObj = mapCandidate.get(SD_KEY);
                    Map<String, SelectedClaim> revealed = null;
                    revealed = ClaimsEvaluator.getStringSelectedClaimMap(disclosures, sdObj);
                    LinkedHashMap<String, SelectedClaim> merged = new LinkedHashMap<String, SelectedClaim>();
                    merged.putAll(revealed);
                    for (Map.Entry e : mapCandidate.entrySet()) {
                        String k = String.valueOf(e.getKey());
                        if (SD_KEY.equals(k)) continue;
                        merged.put(k, (SelectedClaim)e.getValue());
                    }
                    candidate = merged;
                }
                if (component instanceof String) {
                    String key = (String)component;
                    if (!(candidate instanceof Map)) {
                        throw new IllegalArgumentException("Expected object for key lookup but found: " + String.valueOf(candidate));
                    }
                    Map map = candidate;
                    if (!map.containsKey(key)) continue;
                    val = map.get(key);
                    if (val instanceof SelectedClaim) {
                        sc = (SelectedClaim)((Object)val);
                        nextSelection.add(sc);
                        continue;
                    }
                    nextSelection.add(new SelectedClaim(val, null));
                    continue;
                }
                if (component == null) {
                    if (!(candidate instanceof List)) {
                        throw new IllegalArgumentException("Expected array for null selector but found: " + String.valueOf(candidate));
                    }
                    list = (List)((Object)candidate);
                    for (Object elem : list) {
                        if (elem instanceof SelectedClaim) {
                            SelectedClaim sc2 = (SelectedClaim)elem;
                            nextSelection.add(sc2);
                            continue;
                        }
                        nextSelection.add(new SelectedClaim(elem, null));
                    }
                    continue;
                }
                if (component instanceof Integer && (index = (Integer)component) >= 0) {
                    if (!(candidate instanceof List)) {
                        throw new IllegalArgumentException("Expected array for index selector but found: " + String.valueOf(candidate));
                    }
                    list = (List)((Object)candidate);
                    if (index >= list.size()) continue;
                    val = list.get(index);
                    if (val instanceof SelectedClaim) {
                        sc = (SelectedClaim)((Object)val);
                        nextSelection.add(sc);
                        continue;
                    }
                    nextSelection.add(new SelectedClaim(val, null));
                    continue;
                }
                throw new IllegalArgumentException("Invalid claim path component: " + String.valueOf(component));
            }
            if (nextSelection.isEmpty()) {
                throw new IllegalArgumentException("No elements selected at path component: " + String.valueOf(component));
            }
            current = nextSelection;
        }
        return current;
    }

    private static Map<String, SelectedClaim> getStringSelectedClaimMap(List<Disclosure> disclosures, Object sdObj) {
        if (!(sdObj instanceof List)) {
            throw new IllegalArgumentException("_sd field must be a list");
        }
        List sdList = (List)sdObj;
        LinkedHashMap<String, SelectedClaim> revealed = new LinkedHashMap<String, SelectedClaim>();
        for (Object hashObj : sdList) {
            if (!(hashObj instanceof String)) continue;
            String hash = (String)hashObj;
            for (Disclosure disclosure : disclosures) {
                String sdHash = disclosure.getSdHash();
                if (!hash.equals(sdHash)) continue;
                revealed.put(disclosure.getClaim(), new SelectedClaim(disclosure.getValue(), sdHash));
            }
        }
        return revealed;
    }

    private record SelectedClaim(Object value, String hash) {
    }
}

