/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.CredentialEvaluator;
import io.github.wistefan.dcql.CredentialMapper;
import io.github.wistefan.dcql.QueryResult;
import io.github.wistefan.dcql.model.ClaimsQuery;
import io.github.wistefan.dcql.model.Credential;
import io.github.wistefan.dcql.model.CredentialFormat;
import io.github.wistefan.dcql.model.CredentialQuery;
import io.github.wistefan.dcql.model.CredentialSetQuery;
import io.github.wistefan.dcql.model.DcqlQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCQLEvaluator {
    private static final Logger log = LoggerFactory.getLogger(DCQLEvaluator.class);
    private static final String DEFAULT_KEY = "credentials";
    private final List<CredentialEvaluator> credentialEvaluators;

    public QueryResult evaluateDCQLQuery(DcqlQuery dcqlQuery, List<Credential> credentialsList) {
        if (DCQLEvaluator.containsCredentialSets(dcqlQuery)) {
            LinkedHashMap<Object, List<Credential>> resultMap = new LinkedHashMap<Object, List<Credential>>();
            DCQLEvaluator.validateIds(dcqlQuery.getCredentials());
            HashMap<String, CredentialQuery> credentialQueryMap = new HashMap<String, CredentialQuery>();
            dcqlQuery.getCredentials().forEach(cq -> credentialQueryMap.put(cq.getId(), (CredentialQuery)cq));
            for (CredentialSetQuery credentialSetQuery : dcqlQuery.getCredentialSets()) {
                List<Credential> credentialsForSet = this.evaluateCredentialSetQuery(credentialQueryMap, credentialSetQuery, credentialsList);
                if (credentialsForSet.isEmpty() && credentialSetQuery.getRequired().booleanValue()) {
                    log.debug("The query cannot be fulfilled, since a required set is empty.");
                    return new QueryResult(false, Map.of());
                }
                resultMap.put(DCQLEvaluator.purposeOrRandom(credentialSetQuery), credentialsForSet);
            }
            return new QueryResult(true, resultMap);
        }
        ArrayList<Credential> selectedCredentials = new ArrayList<Credential>();
        for (CredentialQuery cq2 : dcqlQuery.getCredentials()) {
            List<Credential> credentialsFullfilling = this.evaluateCredentialQuery(cq2, credentialsList);
            if (credentialsFullfilling.isEmpty()) {
                log.debug("When one of the credentials requirements is not fulfilled, the query should fail.");
                return new QueryResult(false, Map.of());
            }
            if (!cq2.getMultiple().booleanValue() && credentialsFullfilling.size() != 1) {
                log.debug("Multiple credentials where returend for a query not allowing multiple.");
                return new QueryResult(false, Map.of());
            }
            selectedCredentials.addAll(credentialsFullfilling);
        }
        return new QueryResult(true, Map.of(DEFAULT_KEY, selectedCredentials));
    }

    private List<Credential> evaluateCredentialSetQuery(Map<String, CredentialQuery> credentialQueryMap, CredentialSetQuery credentialSetQuery, List<Credential> credentials) {
        for (List<String> option : credentialSetQuery.getOptions()) {
            HashSet fullfillingCredentials = new HashSet();
            fullfillingCredentials.addAll(option.stream().map(credentialQueryMap::get).map(cq -> this.evaluateCredentialQuery((CredentialQuery)cq, credentials)).flatMap(Collection::stream).collect(Collectors.toSet()));
            if (fullfillingCredentials.isEmpty()) continue;
            return new ArrayList<Credential>(fullfillingCredentials);
        }
        return List.of();
    }

    private List<Credential> evaluateCredentialQuery(CredentialQuery credentialQuery, List<Credential> credentialsList) {
        if (!DCQLEvaluator.containsClaims(credentialQuery) && DCQLEvaluator.containsClaimSets(credentialQuery)) {
            throw new IllegalArgumentException("Queries with claim_set require to have claims, too.");
        }
        List<Credential> filteredByFormat = DCQLEvaluator.filterByFormat(credentialQuery.getFormat(), credentialsList);
        CredentialEvaluator credentialEvaluator = this.credentialEvaluators.stream().filter(evaluator -> evaluator.supportedFormat() == credentialQuery.getFormat()).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("The format %s is not supported. Consider registering a matching evaluator.", new Object[]{credentialQuery.getFormat()})));
        return credentialEvaluator.evaluate(credentialQuery, credentialEvaluator.translate(filteredByFormat));
    }

    protected static <T> List<Credential> evaluateForClaimSet(CredentialQuery credentialQuery, List<T> initialCredentials, BiFunction<ClaimsQuery, List<T>, List<T>> evaluationFunction) {
        HashMap claimsQueryMap = new HashMap();
        credentialQuery.getClaims().forEach(cq -> claimsQueryMap.put(cq.getId(), cq));
        for (List<String> claimSet : credentialQuery.getClaimSets()) {
            List<T> credentialsForClaimSet = new ArrayList<T>(initialCredentials);
            for (String claimId : claimSet) {
                ClaimsQuery claimsQuery = (ClaimsQuery)claimsQueryMap.get(claimId);
                credentialsForClaimSet = evaluationFunction.apply(claimsQuery, credentialsForClaimSet);
            }
            if (credentialsForClaimSet.isEmpty()) continue;
            return CredentialMapper.toCredentials(credentialQuery.getFormat(), credentialsForClaimSet);
        }
        return List.of();
    }

    private static List<Credential> filterByFormat(CredentialFormat credentialFormat, List<Credential> credentialsList) {
        return credentialsList.stream().filter(c -> c.getCredentialFormat() == credentialFormat).toList();
    }

    public static boolean containsClaims(CredentialQuery credentialQuery) {
        return credentialQuery.getClaims() != null && !credentialQuery.getClaims().isEmpty();
    }

    public static boolean containsClaimSets(CredentialQuery credentialQuery) {
        return credentialQuery.getClaimSets() != null && !credentialQuery.getClaimSets().isEmpty();
    }

    public static boolean containsMeta(CredentialQuery credentialQuery) {
        return credentialQuery.getMeta() != null && !credentialQuery.getMeta().isEmpty();
    }

    public static boolean containsTrustAuthorities(CredentialQuery credentialQuery) {
        return credentialQuery.getTrustedAuthorities() != null && !credentialQuery.getTrustedAuthorities().isEmpty();
    }

    public static boolean containsCredentialSets(DcqlQuery dcqlQuery) {
        return dcqlQuery.getCredentialSets() != null && !dcqlQuery.getCredentialSets().isEmpty();
    }

    private static void validateIds(List<CredentialQuery> credentialQueries) {
        if (credentialQueries.stream().anyMatch(cq -> cq.getId() == null)) {
            throw new IllegalArgumentException("All credentialQueries need to contain an id.");
        }
    }

    private static Object purposeOrRandom(CredentialSetQuery credentialSetQuery) {
        return Optional.ofNullable(credentialSetQuery.getPurpose()).orElse(UUID.randomUUID().toString());
    }

    public DCQLEvaluator(List<CredentialEvaluator> credentialEvaluators) {
        this.credentialEvaluators = credentialEvaluators;
    }
}

