/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.ClaimsEvaluator;
import io.github.wistefan.dcql.CredentialEvaluator;
import io.github.wistefan.dcql.CredentialMapper;
import io.github.wistefan.dcql.DCQLEvaluator;
import io.github.wistefan.dcql.model.ClaimsQuery;
import io.github.wistefan.dcql.model.Credential;
import io.github.wistefan.dcql.model.CredentialFormat;
import io.github.wistefan.dcql.model.CredentialQuery;
import io.github.wistefan.dcql.model.W3CMetaData;
import io.github.wistefan.dcql.model.credential.LdpCredential;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LdpCredentialEvaluator
implements CredentialEvaluator<LdpCredential> {
    @Override
    public CredentialFormat supportedFormat() {
        return CredentialFormat.LDP_VC;
    }

    @Override
    public List<LdpCredential> translate(List<Credential> credentials) {
        return CredentialMapper.toLdpCredentials(credentials);
    }

    @Override
    public List<Credential> evaluate(CredentialQuery credentialQuery, List<LdpCredential> ldpCredentials) {
        if (DCQLEvaluator.containsMeta(credentialQuery)) {
            ldpCredentials = LdpCredentialEvaluator.filterLdpByMetadata(credentialQuery.getMeta(), ldpCredentials);
        }
        if (DCQLEvaluator.containsClaims(credentialQuery) && !DCQLEvaluator.containsClaimSets(credentialQuery)) {
            for (ClaimsQuery cq : credentialQuery.getClaims()) {
                ldpCredentials = LdpCredentialEvaluator.evaluateLdpCredentialsClaimQuery(cq, ldpCredentials);
            }
        } else if (DCQLEvaluator.containsClaims(credentialQuery)) {
            return DCQLEvaluator.evaluateForClaimSet(credentialQuery, ldpCredentials, LdpCredentialEvaluator::evaluateLdpCredentialsClaimQuery);
        }
        return CredentialMapper.toCredentials(CredentialFormat.LDP_VC, ldpCredentials);
    }

    private static List<LdpCredential> filterLdpByMetadata(Map<String, Object> metaData, List<LdpCredential> credentialsList) {
        W3CMetaData w3CMetaData = W3CMetaData.fromMeta(metaData);
        return credentialsList.stream().filter(ldpCredential -> w3CMetaData.getTypeValues().stream().anyMatch(metaTypes -> new HashSet<String>(ldpCredential.getType()).containsAll((Collection<?>)metaTypes))).toList();
    }

    private static List<LdpCredential> evaluateLdpCredentialsClaimQuery(ClaimsQuery cq, List<LdpCredential> ldpCredentials) {
        return ldpCredentials.stream().map(credential -> ClaimsEvaluator.evaluateClaimsForLdpCredential(cq, credential)).filter(Optional::isPresent).map(Optional::get).toList();
    }
}

