/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.ClaimsEvaluator;
import io.github.wistefan.dcql.CredentialEvaluator;
import io.github.wistefan.dcql.CredentialMapper;
import io.github.wistefan.dcql.DCQLEvaluator;
import io.github.wistefan.dcql.TrustedAuthoritiesEvaluator;
import io.github.wistefan.dcql.model.ClaimsQuery;
import io.github.wistefan.dcql.model.Credential;
import io.github.wistefan.dcql.model.CredentialFormat;
import io.github.wistefan.dcql.model.CredentialQuery;
import io.github.wistefan.dcql.model.MDocMetaData;
import io.github.wistefan.dcql.model.TrustedAuthorityQuery;
import io.github.wistefan.dcql.model.credential.MDocCredential;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MDocCredentialEvaluator
implements CredentialEvaluator<MDocCredential> {
    private static final String MDOC_NAMESPACE_KEY = "namespaces";

    @Override
    public CredentialFormat supportedFormat() {
        return CredentialFormat.MSO_MDOC;
    }

    @Override
    public List<MDocCredential> translate(List<Credential> credentials) {
        return CredentialMapper.toMDocCredentials(credentials);
    }

    @Override
    public List<Credential> evaluate(CredentialQuery credentialQuery, List<MDocCredential> mDocCredentials) {
        if (DCQLEvaluator.containsMeta(credentialQuery)) {
            mDocCredentials = MDocCredentialEvaluator.filterMDocByMetadata(credentialQuery.getMeta(), mDocCredentials);
        }
        if (DCQLEvaluator.containsTrustAuthorities(credentialQuery)) {
            for (TrustedAuthorityQuery taq : credentialQuery.getTrustedAuthorities()) {
                mDocCredentials = mDocCredentials.stream().filter(credential -> TrustedAuthoritiesEvaluator.evaluateQueryForMDocCredential(taq, credential)).toList();
            }
        }
        MDocCredentialEvaluator.translateMDocQueries(credentialQuery);
        if (DCQLEvaluator.containsClaims(credentialQuery) && !DCQLEvaluator.containsClaimSets(credentialQuery)) {
            for (ClaimsQuery cq : credentialQuery.getClaims()) {
                mDocCredentials = MDocCredentialEvaluator.evaluateMDocCredentialsClaimQuery(cq, mDocCredentials);
            }
        } else if (DCQLEvaluator.containsClaims(credentialQuery)) {
            return DCQLEvaluator.evaluateForClaimSet(credentialQuery, mDocCredentials, MDocCredentialEvaluator::evaluateMDocCredentialsClaimQuery);
        }
        return CredentialMapper.toCredentials(CredentialFormat.MSO_MDOC, mDocCredentials);
    }

    private static List<MDocCredential> filterMDocByMetadata(Map<String, Object> metaData, List<MDocCredential> credentialsList) {
        MDocMetaData mDocMetaData = MDocMetaData.fromMeta(metaData);
        return credentialsList.stream().filter(mDocCredential -> mDocCredential.getDocType().equals(mDocMetaData.getDocType())).toList();
    }

    private static CredentialQuery translateMDocQueries(CredentialQuery credentialQuery) {
        if (credentialQuery.getClaims() == null) {
            return credentialQuery;
        }
        credentialQuery.getClaims().forEach(cq -> {
            if (MDocCredentialEvaluator.isMDocClaimsQuery(cq) && cq.getNamespace() != null) {
                cq.setPath(List.of(MDOC_NAMESPACE_KEY, cq.getNamespace(), cq.getClaimName()));
            } else {
                cq.getPath().addFirst(MDOC_NAMESPACE_KEY);
            }
        });
        return credentialQuery;
    }

    private static List<MDocCredential> evaluateMDocCredentialsClaimQuery(ClaimsQuery cq, List<MDocCredential> mDocCredentials) {
        return mDocCredentials.stream().map(credential -> ClaimsEvaluator.evaluateClaimsForMDocCredential(cq, credential)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private static boolean isMDocClaimsQuery(ClaimsQuery claimsQuery) {
        if (claimsQuery.getNamespace() != null && claimsQuery.getClaimName() == null || claimsQuery.getNamespace() == null && claimsQuery.getClaimName() != null) {
            throw new IllegalArgumentException("When a namespace or claim_name is set, the other parameter is mandatory.");
        }
        return claimsQuery.getIntent_to_retain() != null || claimsQuery.getNamespace() != null;
    }
}

