/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.model.TrustedAuthorityQuery;
import io.github.wistefan.dcql.model.TrustedAuthorityType;
import io.github.wistefan.dcql.model.credential.JwtCredential;
import io.github.wistefan.dcql.model.credential.MDocCredential;
import io.github.wistefan.dcql.model.credential.SdJwtCredential;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedAuthoritiesEvaluator {
    private static final Logger log = LoggerFactory.getLogger(TrustedAuthoritiesEvaluator.class);
    private static final String AKI_EXTENSION = "2.5.29.35";

    public static boolean evaluateQueryForMDocCredential(TrustedAuthorityQuery query, MDocCredential credential) {
        return switch (query.getType()) {
            default -> throw new MatchException(null, null);
            case TrustedAuthorityType.AKI -> TrustedAuthoritiesEvaluator.isInChain(credential.getHeaders().getX5Chain(), query.getValues());
            case TrustedAuthorityType.ETSI_TL -> TrustedAuthoritiesEvaluator.isInEtsiTl(credential.getHeaders().getX5Chain(), query.getValues());
            case TrustedAuthorityType.OPENID_FEDERATION -> TrustedAuthoritiesEvaluator.isInOpenIdFederation(query.getValues());
        };
    }

    public static boolean evaluateQueryForSDJwtCredential(TrustedAuthorityQuery query, SdJwtCredential credential) {
        return TrustedAuthoritiesEvaluator.evaluateQueryForJwtCredential(query, credential.getJwtCredential());
    }

    public static boolean evaluateQueryForJwtCredential(TrustedAuthorityQuery query, JwtCredential credential) {
        return switch (query.getType()) {
            default -> throw new MatchException(null, null);
            case TrustedAuthorityType.AKI -> TrustedAuthoritiesEvaluator.isInChain(credential.getX5Chain(), query.getValues());
            case TrustedAuthorityType.ETSI_TL -> TrustedAuthoritiesEvaluator.isInEtsiTl(credential.getX5Chain(), query.getValues());
            case TrustedAuthorityType.OPENID_FEDERATION -> TrustedAuthoritiesEvaluator.isInOpenIdFederation(query.getValues());
        };
    }

    private static boolean isInOpenIdFederation(List<String> federationValues) {
        throw new UnsupportedOperationException("Querying for OpenId Federation Trust Authorities is not yet supported.");
    }

    private static boolean isInEtsiTl(List<X509Certificate> x5chain, List<String> etsiTls) {
        throw new UnsupportedOperationException("Querying for etsi-tl is not supported at the moment.");
    }

    private static boolean isInChain(List<X509Certificate> x5chain, List<String> akiValues) {
        return x5chain.stream().map(TrustedAuthoritiesEvaluator::getAuthorityKeyIdentifier).filter(Optional::isPresent).map(Optional::get).map(byteArray -> Base64.getUrlEncoder().encodeToString((byte[])byteArray)).anyMatch(akiValues::contains);
    }

    private static List<byte[]> decodeAki(List<String> akiValues) {
        return akiValues.stream().map(v -> Base64.getUrlDecoder().decode((String)v)).toList();
    }

    public static Optional<byte[]> getAuthorityKeyIdentifier(X509Certificate certificate) {
        byte[] extValue = certificate.getExtensionValue(AKI_EXTENSION);
        if (extValue == null) {
            return Optional.empty();
        }
        ASN1OctetString akiOctet = ASN1OctetString.getInstance((Object)extValue);
        ASN1Primitive akiObj = null;
        try {
            akiObj = ASN1Primitive.fromByteArray((byte[])akiOctet.getOctets());
        }
        catch (IOException e) {
            log.debug("Certificate does not contain a valid aki.", (Throwable)e);
            return Optional.empty();
        }
        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)akiObj);
        return Optional.ofNullable(aki.getKeyIdentifier());
    }
}

