/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql.model;

import java.util.List;
import java.util.Map;

public class W3CMetaData {
    private static final String TYPE_VALUES_KEY = "type_values";
    private List<List<String>> typeValues;

    public static W3CMetaData fromMeta(Map<String, Object> metaData) {
        Object object;
        if (metaData.containsKey(TYPE_VALUES_KEY) && (object = metaData.get(TYPE_VALUES_KEY)) instanceof List) {
            List typeValues = (List)object;
            List<Object> typeValuesStrings = typeValues.stream().filter(List.class::isInstance).map(l -> W3CMetaData.mapToStringList((List)l)).toList();
            if (typeValuesStrings.size() != typeValues.size()) {
                throw new IllegalArgumentException(String.format("The type_values %s contain invalid values.", typeValues));
            }
            return new W3CMetaData(typeValues);
        }
        throw new IllegalArgumentException(String.format("Given metaData %s is not w3c-metadata.", metaData));
    }

    private static List<String> mapToStringList(List listToMap) {
        List<Object> stringList = listToMap.stream().filter(String.class::isInstance).map(String.class::cast).toList();
        if (stringList.size() != listToMap.size()) {
            throw new IllegalArgumentException("Not all list entries are strings");
        }
        return stringList;
    }

    public List<List<String>> getTypeValues() {
        return this.typeValues;
    }

    public void setTypeValues(List<List<String>> typeValues) {
        this.typeValues = typeValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof W3CMetaData)) {
            return false;
        }
        W3CMetaData other = (W3CMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<String>> this$typeValues = this.getTypeValues();
        List<List<String>> other$typeValues = other.getTypeValues();
        return !(this$typeValues == null ? other$typeValues != null : !((Object)this$typeValues).equals(other$typeValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof W3CMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<String>> $typeValues = this.getTypeValues();
        result = result * 59 + ($typeValues == null ? 43 : ((Object)$typeValues).hashCode());
        return result;
    }

    public String toString() {
        return "W3CMetaData(typeValues=" + String.valueOf(this.getTypeValues()) + ")";
    }

    public W3CMetaData(List<List<String>> typeValues) {
        this.typeValues = typeValues;
    }

    public W3CMetaData() {
    }
}

