/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.model.Credential;
import io.github.wistefan.dcql.model.CredentialFormat;
import io.github.wistefan.dcql.model.credential.CredentialBase;
import io.github.wistefan.dcql.model.credential.JwtCredential;
import io.github.wistefan.dcql.model.credential.LdpCredential;
import io.github.wistefan.dcql.model.credential.MDocCredential;
import io.github.wistefan.dcql.model.credential.SdJwtCredential;
import java.util.ArrayList;
import java.util.List;

public class CredentialMapper {
    public static List<Credential> toCredentials(CredentialFormat credentialFormat, List<?> rawCredentials) {
        return rawCredentials.stream().filter(CredentialBase.class::isInstance).map(CredentialBase.class::cast).map(rC -> new Credential(credentialFormat, (CredentialBase)rC)).toList();
    }

    public static List<LdpCredential> toLdpCredentials(List<Credential> credentialsList) {
        ArrayList<LdpCredential> ldpCredentialsList = new ArrayList<LdpCredential>();
        for (Credential c : credentialsList) {
            CredentialBase credentialBase = c.getRawCredential();
            if (credentialBase instanceof LdpCredential) {
                LdpCredential ldpCredential = (LdpCredential)credentialBase;
                ldpCredentialsList.add(ldpCredential);
                continue;
            }
            throw new IllegalArgumentException("The given credential does not contain an ldp_vc.");
        }
        return ldpCredentialsList;
    }

    public static List<MDocCredential> toMDocCredentials(List<Credential> credentialsList) {
        ArrayList<MDocCredential> mDocCredentialsList = new ArrayList<MDocCredential>();
        for (Credential c : credentialsList) {
            CredentialBase credentialBase = c.getRawCredential();
            if (credentialBase instanceof MDocCredential) {
                MDocCredential mDocCredential = (MDocCredential)credentialBase;
                mDocCredentialsList.add(mDocCredential);
                continue;
            }
            throw new IllegalArgumentException("The given credential does not contain an mso_mdoc.");
        }
        return mDocCredentialsList;
    }

    public static List<JwtCredential> toJWTCredentials(List<Credential> credentialsList) {
        ArrayList<JwtCredential> jwtCredentialsList = new ArrayList<JwtCredential>();
        for (Credential c : credentialsList) {
            CredentialBase credentialBase = c.getRawCredential();
            if (credentialBase instanceof JwtCredential) {
                JwtCredential jwtCredential = (JwtCredential)credentialBase;
                jwtCredentialsList.add(jwtCredential);
                continue;
            }
            throw new IllegalArgumentException("The given credential does not contain an jwt_vc_json.");
        }
        return jwtCredentialsList;
    }

    public static List<SdJwtCredential> toSdJWTCredentials(List<Credential> credentialsList) {
        ArrayList<SdJwtCredential> sdJwtCredentialsList = new ArrayList<SdJwtCredential>();
        for (Credential c : credentialsList) {
            CredentialBase credentialBase = c.getRawCredential();
            if (credentialBase instanceof SdJwtCredential) {
                SdJwtCredential sdJWTCredential = (SdJwtCredential)credentialBase;
                sdJwtCredentialsList.add(sdJWTCredential);
                continue;
            }
            throw new IllegalArgumentException("The given credential does not contain an vc+sd-jwt/dc+sd-jwt.");
        }
        return sdJwtCredentialsList;
    }
}

