/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.ClaimsEvaluator;
import io.github.wistefan.dcql.CredentialEvaluator;
import io.github.wistefan.dcql.CredentialMapper;
import io.github.wistefan.dcql.DCQLEvaluator;
import io.github.wistefan.dcql.TrustedAuthoritiesEvaluator;
import io.github.wistefan.dcql.model.ClaimsQuery;
import io.github.wistefan.dcql.model.Credential;
import io.github.wistefan.dcql.model.CredentialFormat;
import io.github.wistefan.dcql.model.CredentialQuery;
import io.github.wistefan.dcql.model.TrustedAuthorityQuery;
import io.github.wistefan.dcql.model.W3CMetaData;
import io.github.wistefan.dcql.model.credential.JwtCredential;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JwtCredentialEvaluator
implements CredentialEvaluator<JwtCredential> {
    @Override
    public CredentialFormat supportedFormat() {
        return CredentialFormat.JWT_VC_JSON;
    }

    @Override
    public List<JwtCredential> translate(List<Credential> credentials) {
        return CredentialMapper.toJWTCredentials(credentials);
    }

    @Override
    public List<Credential> evaluate(CredentialQuery credentialQuery, List<JwtCredential> jwtCredentials) {
        if (DCQLEvaluator.containsMeta(credentialQuery)) {
            jwtCredentials = JwtCredentialEvaluator.filterJwtByMetadata(credentialQuery.getMeta(), jwtCredentials);
        }
        if (DCQLEvaluator.containsTrustAuthorities(credentialQuery)) {
            for (TrustedAuthorityQuery taq : credentialQuery.getTrustedAuthorities()) {
                jwtCredentials = jwtCredentials.stream().filter(credential -> TrustedAuthoritiesEvaluator.evaluateQueryForJwtCredential(taq, credential)).toList();
            }
        }
        if (DCQLEvaluator.containsClaims(credentialQuery) && !DCQLEvaluator.containsClaimSets(credentialQuery)) {
            for (ClaimsQuery cq : credentialQuery.getClaims()) {
                jwtCredentials = JwtCredentialEvaluator.evaluateJwtCredentialsClaimQuery(cq, jwtCredentials);
            }
        } else if (DCQLEvaluator.containsClaims(credentialQuery)) {
            return DCQLEvaluator.evaluateForClaimSet(credentialQuery, jwtCredentials, JwtCredentialEvaluator::evaluateJwtCredentialsClaimQuery);
        }
        return CredentialMapper.toCredentials(CredentialFormat.JWT_VC_JSON, jwtCredentials);
    }

    private static List<JwtCredential> filterJwtByMetadata(Map<String, Object> metaData, List<JwtCredential> credentialsList) {
        W3CMetaData w3CMetaData = W3CMetaData.fromMeta(metaData);
        return credentialsList.stream().filter(jwtCredential -> w3CMetaData.getTypeValues().stream().anyMatch(metaTypes -> new HashSet<String>(jwtCredential.getType()).containsAll((Collection<?>)metaTypes))).toList();
    }

    private static List<JwtCredential> evaluateJwtCredentialsClaimQuery(ClaimsQuery cq, List<JwtCredential> jwtCredentials) {
        return jwtCredentials.stream().map(credential -> ClaimsEvaluator.evaluateClaimsForJwtCredential(cq, credential)).filter(Optional::isPresent).map(Optional::get).toList();
    }
}

