/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql.model;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JwtMetaData {
    private static final String VCT_VALUES_KEY = "vct_values";
    private Set<String> vctValues;

    public static JwtMetaData fromMeta(Map<String, Object> metaData) {
        Object object;
        if (metaData.containsKey(VCT_VALUES_KEY) && (object = metaData.get(VCT_VALUES_KEY)) instanceof List) {
            List vctValues = (List)object;
            List<Object> vctStrings = vctValues.stream().filter(String.class::isInstance).map(String.class::cast).toList();
            if (vctValues.size() != vctStrings.size()) {
                throw new IllegalArgumentException(String.format("The vct_values %s contain invalid values.", vctValues));
            }
            return new JwtMetaData(new HashSet<Object>(vctStrings));
        }
        throw new IllegalArgumentException(String.format("Given metaData %s is not sdJwt-metadata.", metaData));
    }

    public Set<String> getVctValues() {
        return this.vctValues;
    }

    public void setVctValues(Set<String> vctValues) {
        this.vctValues = vctValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtMetaData)) {
            return false;
        }
        JwtMetaData other = (JwtMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$vctValues = this.getVctValues();
        Set<String> other$vctValues = other.getVctValues();
        return !(this$vctValues == null ? other$vctValues != null : !((Object)this$vctValues).equals(other$vctValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $vctValues = this.getVctValues();
        result = result * 59 + ($vctValues == null ? 43 : ((Object)$vctValues).hashCode());
        return result;
    }

    public String toString() {
        return "JwtMetaData(vctValues=" + String.valueOf(this.getVctValues()) + ")";
    }

    public JwtMetaData(Set<String> vctValues) {
        this.vctValues = vctValues;
    }

    public JwtMetaData() {
    }
}

