/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql.model.credential;

import io.github.wistefan.dcql.EvaluationException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class Disclosure {
    private String salt;
    private String claim;
    private Object value;
    private final String encodedDisclosure;
    private final String sdHash;

    public Disclosure(String salt, String claim, Object value, String encodedDisclosure, String sdAlgorithm) {
        this.salt = salt;
        this.claim = claim;
        this.value = value;
        this.encodedDisclosure = encodedDisclosure;
        this.sdHash = this.generateSdHash(sdAlgorithm);
    }

    private String generateSdHash(String sdAlgorithm) {
        byte[] disclosureBytes = this.encodedDisclosure.getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = this.getMessageDigest(sdAlgorithm);
        byte[] hash = digest.digest(disclosureBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
    }

    private MessageDigest getMessageDigest(String sdAlgorithm) {
        if (sdAlgorithm.equalsIgnoreCase("SHA-256")) {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new EvaluationException(String.format("SD-Algorithm %s is not supported.", sdAlgorithm), e);
            }
        }
        throw new EvaluationException(String.format("SD-Algorithm %s is not supported.", sdAlgorithm));
    }

    public String getSalt() {
        return this.salt;
    }

    public String getClaim() {
        return this.claim;
    }

    public Object getValue() {
        return this.value;
    }

    public String getEncodedDisclosure() {
        return this.encodedDisclosure;
    }

    public String getSdHash() {
        return this.sdHash;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setClaim(String claim) {
        this.claim = claim;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return "Disclosure(salt=" + this.getSalt() + ", claim=" + this.getClaim() + ", value=" + String.valueOf(this.getValue()) + ", encodedDisclosure=" + this.getEncodedDisclosure() + ", sdHash=" + this.getSdHash() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Disclosure)) {
            return false;
        }
        Disclosure other = (Disclosure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$claim = this.getClaim();
        String other$claim = other.getClaim();
        if (this$claim == null ? other$claim != null : !this$claim.equals(other$claim)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$encodedDisclosure = this.getEncodedDisclosure();
        String other$encodedDisclosure = other.getEncodedDisclosure();
        if (this$encodedDisclosure == null ? other$encodedDisclosure != null : !this$encodedDisclosure.equals(other$encodedDisclosure)) {
            return false;
        }
        String this$sdHash = this.getSdHash();
        String other$sdHash = other.getSdHash();
        return !(this$sdHash == null ? other$sdHash != null : !this$sdHash.equals(other$sdHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Disclosure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $claim = this.getClaim();
        result = result * 59 + ($claim == null ? 43 : $claim.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $encodedDisclosure = this.getEncodedDisclosure();
        result = result * 59 + ($encodedDisclosure == null ? 43 : $encodedDisclosure.hashCode());
        String $sdHash = this.getSdHash();
        result = result * 59 + ($sdHash == null ? 43 : $sdHash.hashCode());
        return result;
    }
}

