/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql.model.credential;

import io.github.wistefan.dcql.model.credential.CredentialBase;
import io.github.wistefan.dcql.model.credential.Disclosure;
import io.github.wistefan.dcql.model.credential.JwtCredential;
import java.util.List;
import java.util.StringJoiner;

public class SdJwtCredential
extends CredentialBase {
    private static final String SD_JWT_SEPARATOR = "~";
    private JwtCredential jwtCredential;
    private List<Disclosure> disclosures;

    public SdJwtCredential(String raw, JwtCredential jwtCredential, List<Disclosure> disclosures) {
        super(raw);
        this.jwtCredential = jwtCredential;
        this.disclosures = disclosures;
    }

    @Override
    public String getRaw() {
        if (this.raw == null) {
            return null;
        }
        String[] splittedRaw = super.getRaw().split(SD_JWT_SEPARATOR);
        StringJoiner sdJoiner = new StringJoiner(SD_JWT_SEPARATOR);
        sdJoiner.add(splittedRaw[0]);
        this.disclosures.stream().map(Disclosure::getEncodedDisclosure).forEach(sdJoiner::add);
        return String.valueOf(sdJoiner) + SD_JWT_SEPARATOR;
    }

    public String getVct() {
        return this.jwtCredential.getVct();
    }

    public List<String> getType() {
        return this.jwtCredential.getType();
    }

    public JwtCredential getJwtCredential() {
        return this.jwtCredential;
    }

    public List<Disclosure> getDisclosures() {
        return this.disclosures;
    }
}

