/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql;

import io.github.wistefan.dcql.ClaimsEvaluator;
import io.github.wistefan.dcql.CredentialEvaluator;
import io.github.wistefan.dcql.CredentialMapper;
import io.github.wistefan.dcql.DCQLEvaluator;
import io.github.wistefan.dcql.TrustedAuthoritiesEvaluator;
import io.github.wistefan.dcql.model.ClaimsQuery;
import io.github.wistefan.dcql.model.Credential;
import io.github.wistefan.dcql.model.CredentialQuery;
import io.github.wistefan.dcql.model.JwtMetaData;
import io.github.wistefan.dcql.model.TrustedAuthorityQuery;
import io.github.wistefan.dcql.model.credential.Disclosure;
import io.github.wistefan.dcql.model.credential.SdJwtCredential;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class SdJwtCredentialEvaluator
implements CredentialEvaluator<SdJwtCredential> {
    @Override
    public List<SdJwtCredential> translate(List<Credential> credentials) {
        return CredentialMapper.toSdJWTCredentials(credentials);
    }

    @Override
    public List<Credential> evaluate(CredentialQuery credentialQuery, List<SdJwtCredential> sdJwtCredentials) {
        if (DCQLEvaluator.containsMeta(credentialQuery)) {
            sdJwtCredentials = SdJwtCredentialEvaluator.filterSdJwtByMetadata(credentialQuery.getMeta(), sdJwtCredentials);
        }
        if (DCQLEvaluator.containsTrustAuthorities(credentialQuery)) {
            for (TrustedAuthorityQuery taq : credentialQuery.getTrustedAuthorities()) {
                sdJwtCredentials = sdJwtCredentials.stream().filter(credential -> TrustedAuthoritiesEvaluator.evaluateQueryForSDJwtCredential(taq, credential)).toList();
            }
        }
        if (DCQLEvaluator.containsClaims(credentialQuery) && !DCQLEvaluator.containsClaimSets(credentialQuery)) {
            sdJwtCredentials = SdJwtCredentialEvaluator.evaluateSdJwtCredentialsQuery(credentialQuery, sdJwtCredentials);
        } else {
            if (DCQLEvaluator.containsClaims(credentialQuery)) {
                return SdJwtCredentialEvaluator.evaluateSdJwtForClaimSet(credentialQuery, sdJwtCredentials);
            }
            sdJwtCredentials = sdJwtCredentials.stream().map(sdJwtCredential -> new SdJwtCredential(sdJwtCredential.getRaw(), sdJwtCredential.getJwtCredential(), List.of())).toList();
        }
        return CredentialMapper.toCredentials(credentialQuery.getFormat(), sdJwtCredentials);
    }

    private static List<SdJwtCredential> filterSdJwtByMetadata(Map<String, Object> metaData, List<SdJwtCredential> credentialsList) {
        JwtMetaData jwtMetaData = JwtMetaData.fromMeta(metaData);
        return credentialsList.stream().filter(sdJwtCredential -> jwtMetaData.getVctValues().contains(sdJwtCredential.getVct())).toList();
    }

    private static List<SdJwtCredential> evaluateSdJwtCredentialsQuery(CredentialQuery credentialQuery, List<SdJwtCredential> sdJwtCredentials) {
        ArrayList<SdJwtCredential> disclosedCredentials = new ArrayList<SdJwtCredential>();
        for (SdJwtCredential credential : sdJwtCredentials) {
            Set selectedDisclosures = credentialQuery.getClaims().stream().map(cq -> ClaimsEvaluator.evaluateClaimsForSdJwtCredential(cq, credential)).filter(Optional::isPresent).map(Optional::get).map(SdJwtCredential::getDisclosures).flatMap(Collection::stream).collect(Collectors.toSet());
            disclosedCredentials.add(new SdJwtCredential(credential.getRaw(), credential.getJwtCredential(), new ArrayList<Disclosure>(selectedDisclosures)));
        }
        return disclosedCredentials;
    }

    private static List<Credential> evaluateSdJwtForClaimSet(CredentialQuery credentialQuery, List<SdJwtCredential> sdJwtCredentials) {
        HashMap claimsQueryMap = new HashMap();
        credentialQuery.getClaims().forEach(cq -> claimsQueryMap.put(cq.getId(), cq));
        for (List<String> claimSet : credentialQuery.getClaimSets()) {
            ArrayList<SdJwtCredential> disclosedCredentials = new ArrayList<SdJwtCredential>();
            for (SdJwtCredential credential : sdJwtCredentials) {
                HashSet disclosures = new HashSet();
                for (String claimId : claimSet) {
                    ClaimsQuery claimsQuery = (ClaimsQuery)claimsQueryMap.get(claimId);
                    disclosures.addAll(new HashSet(ClaimsEvaluator.evaluateClaimsForSdJwtCredential(claimsQuery, credential).map(SdJwtCredential::getDisclosures).orElse(new ArrayList())));
                }
                if (disclosures.isEmpty()) continue;
                disclosedCredentials.add(new SdJwtCredential(credential.getRaw(), credential.getJwtCredential(), new ArrayList<Disclosure>(disclosures)));
            }
            if (disclosedCredentials.isEmpty()) continue;
            return CredentialMapper.toCredentials(credentialQuery.getFormat(), disclosedCredentials);
        }
        return List.of();
    }
}

