/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql.model;

import java.util.Arrays;

public enum CredentialFormat {
    MSO_MDOC("mso_mdoc"),
    VC_SD_JWT("vc+sd-jwt"),
    DC_SD_JWT("dc+sd-jwt"),
    LDP_VC("ldp_vc"),
    JWT_VC_JSON("jwt_vc_json");

    private final String value;

    private CredentialFormat(String value) {
        this.value = value;
    }

    public static CredentialFormat fromValue(String value) {
        return Arrays.stream(CredentialFormat.values()).filter(eV -> eV.getValue().equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown value %s.", value)));
    }

    public String getValue() {
        return this.value;
    }
}

