/*
 * Decompiled with CFR 0.152.
 */
package io.github.wistefan.dcql.model.credential;

import io.github.wistefan.dcql.model.credential.CredentialBase;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

public class JwtCredential
extends CredentialBase {
    private static final String VC_PAYLOAD_KEY = "vc";
    private static final String VCT_KEY = "vct";
    private static final String TYPE_KEY = "type";
    private static final String X5C_KEY = "x5c";
    private final Map<String, Object> headers;
    private final Map<String, Object> payload;
    private final String signature;

    public JwtCredential(String raw, Map<String, Object> headers, Map<String, Object> payload, String signature) {
        super(raw);
        this.headers = headers;
        this.payload = payload;
        this.signature = signature;
    }

    public List<X509Certificate> getX5Chain() {
        Object object;
        if (this.headers.containsKey(X5C_KEY) && (object = this.headers.get(X5C_KEY)) instanceof List) {
            List x5Chain = (List)object;
            List<Object> x509Certificates = x5Chain.stream().filter(X509Certificate.class::isInstance).map(X509Certificate.class::cast).toList();
            if (x5Chain.size() != x509Certificates.size()) {
                throw new IllegalArgumentException("The x5c header contains invalid values.");
            }
            return x509Certificates;
        }
        return List.of();
    }

    public Map<String, Object> getPayload() {
        if (this.payload.containsKey(VC_PAYLOAD_KEY)) {
            return (Map)this.payload.get(VC_PAYLOAD_KEY);
        }
        return this.payload;
    }

    public List<String> getType() {
        if (this.getPayload().containsKey(TYPE_KEY)) {
            Object object = this.getPayload().get(TYPE_KEY);
            if (object instanceof String) {
                String typeString = (String)object;
                return List.of(typeString);
            }
            object = this.getPayload().get(TYPE_KEY);
            if (object instanceof List) {
                List typeList = (List)object;
                List<Object> typeStrings = typeList.stream().filter(String.class::isInstance).map(String.class::cast).toList();
                if (typeStrings.size() == typeList.size()) {
                    return typeStrings;
                }
            }
        }
        throw new IllegalArgumentException("The type field contains invalid entries.");
    }

    public String getVct() {
        Object object;
        if (this.getPayload().containsKey(VCT_KEY) && (object = this.getPayload().get(VCT_KEY)) instanceof String) {
            String vctValue = (String)object;
            return vctValue;
        }
        throw new IllegalArgumentException("Invalid credential. Does not contain a valid vct.");
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public String getSignature() {
        return this.signature;
    }
}

