/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.account.request.AccountDataRequest;
import com.bybit.api.client.domain.account.request.ResetMMPRequest;
import com.bybit.api.client.domain.account.request.SetCollateralCoinRequest;
import com.bybit.api.client.domain.account.request.SetMMPRequest;
import com.bybit.api.client.domain.account.request.SetMarginModeRequest;
import com.bybit.api.client.domain.account.request.SetSpotHedgingRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncAccountRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncAccountRestClientImpl
implements BybitApiAsyncAccountRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncAccountRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption);
    }

    @Override
    public void getWalletBalance(AccountDataRequest walletBalanceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getWalletBalance(walletBalanceRequest.getAccountType().getAccountTypeValue(), walletBalanceRequest.getCoins()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void upgradeAccountToUTA(BybitApiCallback<Object> callback) {
        this.bybitApiService.upgradeAccountToUTA().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountBorrowHistory(AccountDataRequest borrowHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountBorrowHistory(borrowHistoryRequest.getCurrency(), borrowHistoryRequest.getStartTime(), borrowHistoryRequest.getEndTime(), borrowHistoryRequest.getLimit(), borrowHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAccountCollateralCoin(AccountDataRequest setCollateralCoinRequest, BybitApiCallback<Object> callback) {
        SetCollateralCoinRequest request = this.converter.mapToSetCollateralCoinRequest(setCollateralCoinRequest);
        this.bybitApiService.setAccountCollateralCoin(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountCollateralInfo(AccountDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountCollateralInfo(request.getCurrency()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountCoinGeeks(AccountDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountCoinGeeks(request.getBaseCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountFreeRate(AccountDataRequest getFeeRateRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountFreeRate(getFeeRateRequest.getCategory().getCategoryTypeId(), getFeeRateRequest.getSymbol(), getFeeRateRequest.getBaseCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getTransactionLog(AccountDataRequest getTransactionLogRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getTransactionLog(getTransactionLogRequest.getAccountType() == null ? null : getTransactionLogRequest.getAccountType().getAccountTypeValue(), getTransactionLogRequest.getCategory() == null ? null : getTransactionLogRequest.getCategory().getCategoryTypeId(), getTransactionLogRequest.getCurrency(), getTransactionLogRequest.getBaseCoin(), getTransactionLogRequest.getTransactionType() == null ? null : getTransactionLogRequest.getTransactionType().getTransactionTypeId(), getTransactionLogRequest.getStartTime(), getTransactionLogRequest.getEndTime(), getTransactionLogRequest.getLimit(), getTransactionLogRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAccountMarginMode(AccountDataRequest request, BybitApiCallback<Object> callback) {
        SetMarginModeRequest setMarginMode = this.converter.mapToSetMarginModeRequest(request);
        this.bybitApiService.setAccountMarginMode(setMarginMode).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifyAccountMMP(AccountDataRequest setMMPRequest, BybitApiCallback<Object> callback) {
        SetMMPRequest request = this.converter.mapToSetMMPRequest(setMMPRequest);
        this.bybitApiService.modifyAccountMMP(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void resetAccountMMP(AccountDataRequest request, BybitApiCallback<Object> callback) {
        ResetMMPRequest resetMMPRequest = this.converter.mapToResetMarginModeRequest(request);
        this.bybitApiService.resetAccountMMP(resetMMPRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountMMPState(AccountDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountMMPState(request.getBaseCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAccountSpotHedging(AccountDataRequest request, BybitApiCallback<Object> callback) {
        SetSpotHedgingRequest setSpotHedging = this.converter.mapToSetSpotHedgingModeRequest(request);
        this.bybitApiService.setAccountSpotHedging(setSpotHedging).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

