/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.log;

import com.bybit.api.client.log.LogOption;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BybitApiServiceGenerator.class);

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.logHeaders(request.headers(), "--- request header ---");
        Response response = chain.proceed(request);
        this.logHeaders(response.headers(), "--- response header ---");
        return response;
    }

    private void logHeaders(Headers headers, String headerTitle) {
        LOGGER.info(headerTitle);
        for (String name : headers.names()) {
            LOGGER.info("{}: {}", (Object)name, (Object)headers.get(name));
        }
        LOGGER.info("-----------------------");
    }

    public static void HandleLoggingInterceptor(OkHttpClient.Builder clientBuilder, String logOption) {
        LOGGER.info("Debug Mode Activated, Trace Request in body level");
        if (LogOption.SLF4J.getLogOptionType().equals(logOption.trim().toLowerCase())) {
            clientBuilder.addInterceptor((Interceptor)new Slf4jLoggingInterceptor());
        } else if (LogOption.OKHTTP3.getLogOptionType().equals(logOption.trim().toLowerCase())) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOGGER).info(arg_0));
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            clientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        }
    }
}

