/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.bybit.api.client.domain.asset.request.AssetDataRequest;
import com.bybit.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetWithdrawRequest;
import com.bybit.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.bybit.api.client.restApi.BybitApiAssetRestClient;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAssetRestClientImpl
implements BybitApiAssetRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAssetRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getAssetCoinExchangeRecords(AssetDataRequest coinExchangeRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetCoinExchangeRecords(coinExchangeRecordsRequest.getFromCoin(), coinExchangeRecordsRequest.getToCoin(), coinExchangeRecordsRequest.getLimit(), coinExchangeRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetDeliveryRecords(AssetDataRequest deliveryRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetDeliveryRecords(deliveryRecordsRequest.getCategory() == null ? null : deliveryRecordsRequest.getCategory().getCategoryTypeId(), deliveryRecordsRequest.getSymbol(), deliveryRecordsRequest.getExpDate(), deliveryRecordsRequest.getLimit(), deliveryRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetUSDCSettlementRecords(AssetDataRequest usdcSettlementRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetUSDCSettlementRecords(usdcSettlementRequest.getCategory() == null ? null : usdcSettlementRequest.getCategory().getCategoryTypeId(), usdcSettlementRequest.getSymbol(), usdcSettlementRequest.getLimit(), usdcSettlementRequest.getCursor()));
    }

    @Override
    public Object getAssetInfo(AssetDataRequest assetInfoRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetInfo(assetInfoRequest.getAccountType() == null ? null : assetInfoRequest.getAccountType().getAccountTypeValue(), assetInfoRequest.getCoin()));
    }

    @Override
    public Object getAssetAllCoinsBalance(AssetDataRequest allCoinsBalanceRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetAllCoinsBalance(allCoinsBalanceRequest.getAccountType() == null ? null : allCoinsBalanceRequest.getAccountType().getAccountTypeValue(), allCoinsBalanceRequest.getMemberId(), allCoinsBalanceRequest.getCoin(), allCoinsBalanceRequest.getWithBonus() == null ? null : String.valueOf(allCoinsBalanceRequest.getWithBonus().getValue())));
    }

    @Override
    public Object getAssetTransferableCoins(AssetDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetTransferableCoins(request.getFromAccountType() == null ? null : request.getFromAccountType().getAccountTypeValue(), request.getToAccountType() == null ? null : request.getToAccountType().getAccountTypeValue()));
    }

    @Override
    public Object getAssetSingleCoinBalance(AssetDataRequest singleCoinBalanceRequest) {
        return BybitApiServiceGenerator.executeSync(this.converter.getSingleCoinBalance(this.bybitApiService, singleCoinBalanceRequest));
    }

    @Override
    public Object createAssetInternalTransfer(AssetDataRequest assetInternalTransferRequest) {
        AssetInternalTransferRequest request = this.converter.mapToAssetInternalTransferRequest(assetInternalTransferRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createAssetInternalTransfer(request));
    }

    @Override
    public Object getAssetTransferSubUidList() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetTransferSubUidList());
    }

    @Override
    public Object createAssetUniversalTransfer(AssetDataRequest assetUniversalTransferRequest) {
        AssetUniversalTransferRequest request = this.converter.mapToAssetUniversalTransferRequest(assetUniversalTransferRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createAssetUniversalTransfer(request));
    }

    @Override
    public Object getAssetInternalTransferRecords(AssetDataRequest internalTransferRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetInternalTransferRecords(internalTransferRequest.getTransferId(), internalTransferRequest.getCoin(), internalTransferRequest.getTransferStatus() == null ? null : internalTransferRequest.getTransferStatus().getStatus(), internalTransferRequest.getStartTime(), internalTransferRequest.getEndTime(), internalTransferRequest.getLimit(), internalTransferRequest.getCursor()));
    }

    @Override
    public Object getAssetUniversalTransferRecords(AssetDataRequest universalTransferRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetUniversalTransferRecords(universalTransferRequest.getTransferId(), universalTransferRequest.getCoin(), universalTransferRequest.getTransferStatus() == null ? null : universalTransferRequest.getTransferStatus().getStatus(), universalTransferRequest.getStartTime(), universalTransferRequest.getEndTime(), universalTransferRequest.getLimit(), universalTransferRequest.getCursor()));
    }

    @Override
    public Object getAssetAllowedDepositCoinInfo(AssetDataRequest allowedDepositCoinRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetAllowedDepositCoinInfo(allowedDepositCoinRequest.getCoin(), allowedDepositCoinRequest.getChain(), allowedDepositCoinRequest.getLimit(), allowedDepositCoinRequest.getCursor()));
    }

    @Override
    public Object setAssetDepositAccount(AssetDataRequest request) {
        SetAssetDepositAccountRequest setAssetDepositAccountRequest = this.converter.mapToSetDepositAccountRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAssetDepositAccount(setAssetDepositAccountRequest));
    }

    @Override
    public Object getAssetDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetSubMembersDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetSubMembersDepositRecords(assetDepositRecordsRequest.getSubMemberId(), assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetInternalDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetInternalDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetMasterDepositAddress(AssetDataRequest masterDepositRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetMasterDepositAddress(masterDepositRequest.getCoin(), masterDepositRequest.getChainType()));
    }

    @Override
    public Object getAssetSubMemberDepositAddress(AssetDataRequest subDepositRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetSubMemberDepositAddress(subDepositRequest.getCoin(), subDepositRequest.getChainType(), subDepositRequest.getSubMemberId()));
    }

    @Override
    public Object getAssetCoinInfo(AssetDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetCoinInfo(request.getCoin()));
    }

    @Override
    public Object getAssetWithdrawalAmount(AssetDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetWithdrawalAmount(request.getCoin()));
    }

    @Override
    public Object getAssetWithdrawalRecords(AssetDataRequest assetWithdrawRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetWithdrawalRecords(assetWithdrawRecordsRequest.getWithdrawID(), assetWithdrawRecordsRequest.getCoin(), assetWithdrawRecordsRequest.getWithdrawType() == null ? null : Integer.valueOf(assetWithdrawRecordsRequest.getWithdrawType().getValue()), assetWithdrawRecordsRequest.getStartTime(), assetWithdrawRecordsRequest.getEndTime(), assetWithdrawRecordsRequest.getLimit(), assetWithdrawRecordsRequest.getCursor()));
    }

    @Override
    public Object cancelAssetWithdraw(AssetDataRequest request) {
        AssetCancelWithdrawRequest assetCancelWithdrawRequest = this.converter.mapToAssetCancelWithdrawRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAssetWithdraw(assetCancelWithdrawRequest));
    }

    @Override
    public Object createAssetWithdraw(AssetDataRequest assetWithdrawRequest) {
        AssetWithdrawRequest request = this.converter.mapToAssetWithdrawRequest(assetWithdrawRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createAssetWithdraw(request));
    }
}

