/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.classgraph.BaseTypeSignature;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeSignature;
import io.github.zero88.exceptions.HiddenException;
import io.github.zero88.exceptions.ReflectionException;
import io.github.zero88.utils.Functions;
import io.github.zero88.utils.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reflections {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reflections.class);

    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray;
        if (classLoaders != null && classLoaders.length != 0) {
            return classLoaders;
        }
        ClassLoader contextClassLoader = Reflections.contextClassLoader();
        ClassLoader staticClassLoader = Reflections.staticClassLoader();
        if (contextClassLoader != null) {
            if (staticClassLoader != null && contextClassLoader != staticClassLoader) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[2];
                classLoaderArray2[0] = contextClassLoader;
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[1] = staticClassLoader;
            } else {
                ClassLoader[] classLoaderArray3 = new ClassLoader[1];
                classLoaderArray = classLoaderArray3;
                classLoaderArray3[0] = contextClassLoader;
            }
        } else {
            classLoaderArray = new ClassLoader[]{};
        }
        return classLoaderArray;
    }

    public static <T extends Member> Predicate<T> hasModifiers(int ... modifiers) {
        int searchMods = Arrays.stream(modifiers).reduce((left, right) -> left | right).orElse(0);
        return member -> (member.getModifiers() & searchMods) == searchMods;
    }

    public static <T extends Member> Predicate<T> notModifiers(int ... modifiers) {
        int searchMods = Arrays.stream(modifiers).reduce((left, right) -> left | right).orElse(0);
        return member -> (member.getModifiers() & searchMods) != searchMods;
    }

    @SafeVarargs
    public static <T extends AnnotatedElement> Predicate<T> hasAnnotation(Class<? extends Annotation> ... annotations) {
        return element -> Arrays.stream(annotations).anyMatch(a -> Objects.nonNull(element.getAnnotation(a)));
    }

    private Reflections() {
    }

    public static class ReflectionClass {
        public static boolean assertDataType(@NonNull Class<?> childClass, @NonNull Class<?> superClass) {
            if (childClass == null) {
                throw new NullPointerException("childClass is marked non-null but is null");
            }
            if (superClass == null) {
                throw new NullPointerException("superClass is marked non-null but is null");
            }
            if (childClass.isPrimitive() && superClass.isPrimitive()) {
                return childClass == superClass;
            }
            if (childClass.isPrimitive()) {
                Class<?> superPrimitiveClass = ReflectionClass.getPrimitiveClass(superClass);
                return childClass == superPrimitiveClass;
            }
            if (superClass.isPrimitive()) {
                Class<?> childPrimitiveClass = ReflectionClass.getPrimitiveClass(childClass);
                return childPrimitiveClass == superClass;
            }
            return superClass.isAssignableFrom(childClass);
        }

        public static boolean isSystemClass(String clazzName) {
            return ReflectionClass.belongsTo(clazzName, "java.", "javax.", "sun.*", "com.sun.");
        }

        public static boolean belongsTo(@NonNull String clazzName, String ... packageNames) {
            if (clazzName == null) {
                throw new NullPointerException("clazzName is marked non-null but is null");
            }
            return Arrays.stream(packageNames).anyMatch(clazzName::startsWith);
        }

        public static boolean isJavaLangObject(@NonNull Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            return clazz.isPrimitive() || clazz.isEnum() || "java.lang".equals(clazz.getPackage().getName());
        }

        private static <T> Class<?> getPrimitiveClass(@NonNull Class<T> findClazz) {
            if (findClazz == null) {
                throw new NullPointerException("findClazz is marked non-null but is null");
            }
            try {
                Field t = findClazz.getField("TYPE");
                if (!Reflections.hasModifiers(1, 8).test(t)) {
                    return null;
                }
                Object primitiveClazz = t.get(null);
                if (primitiveClazz instanceof Class) {
                    return (Class)primitiveClazz;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOGGER.trace("Try casting primitive class from class " + findClazz.getName(), (Throwable)e);
            }
            return null;
        }

        public static <T> Stream<Class<T>> stream(String packageName, Class<T> parentClass) {
            return ReflectionClass.stream(packageName, parentClass, (ClassInfo clazz) -> true);
        }

        public static <T> Stream<Class<T>> stream(String packageName, Class<T> parentClass, @NonNull Class<? extends Annotation> annotationClass) {
            if (annotationClass == null) {
                throw new NullPointerException("annotationClass is marked non-null but is null");
            }
            return ReflectionClass.stream(packageName, parentClass, (ClassInfo clazz) -> clazz.hasAnnotation(annotationClass.getName()));
        }

        public static <T> Stream<Class<T>> stream(String packageName, Class<T> parentClass, @NonNull Predicate<ClassInfo> filter) {
            if (filter == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            Strings.requireNotBlank(packageName, "Package name cannot be empty");
            ClassGraph graph = new ClassGraph().enableAnnotationInfo().ignoreClassVisibility().whitelistPackages(new String[]{packageName});
            if (LOGGER.isTraceEnabled()) {
                graph.verbose();
            }
            try (ScanResult scanResult = graph.scan();){
                ClassInfoList infoList = Objects.nonNull(parentClass) ? (parentClass.isInterface() ? scanResult.getClassesImplementing(parentClass.getName()) : scanResult.getSubclasses(parentClass.getName())) : scanResult.getAllClasses();
                Stream<Class<T>> stream = infoList.filter(filter::test).loadClasses().stream().map(clazz -> clazz);
                return stream;
            }
        }

        @NonNull
        public static Predicate<ClassInfo> publicClass() {
            return clazz -> clazz.isStandardClass() && clazz.isPublic() && !clazz.isAbstract();
        }

        public static <T> Class<T> findClass(String clazz) {
            try {
                return Class.forName(Strings.requireNotBlank(clazz), true, Reflections.contextClassLoader());
            }
            catch (ClassCastException | ClassNotFoundException e) {
                LOGGER.debug("Not found class " + clazz, (Throwable)e);
                return null;
            }
        }

        public static <T> T createObject(String clazz) {
            Class<T> aClass = ReflectionClass.findClass(clazz);
            if (Objects.isNull(aClass)) {
                return null;
            }
            return ReflectionClass.createObject(aClass);
        }

        public static <T> T createObject(String clazz, @NonNull Map<Class, Object> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs is marked non-null but is null");
            }
            Class<T> aClass = ReflectionClass.findClass(clazz);
            if (Objects.isNull(aClass)) {
                return null;
            }
            return ReflectionClass.createObject(aClass, inputs);
        }

        public static <T> T createObject(Class<T> clazz) {
            return ReflectionClass.createObject(clazz, new Functions.Silencer()).get();
        }

        public static <T> T createObject(Class<T> clazz, Map<Class, Object> inputs) {
            return ReflectionClass.createObject(clazz, inputs, new Functions.Silencer()).get();
        }

        public static <T> Functions.Silencer<T> createObject(Class<T> clazz, Functions.Silencer<T> silencer) {
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                silencer.accept(constructor.newInstance(new Object[0]), null);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                silencer.accept((Object)null, new HiddenException(new ReflectionException("Cannot init instance of " + clazz.getName(), (Throwable)e)));
            }
            return silencer;
        }

        public static <T> Functions.Silencer<T> createObject(@NonNull Class<T> clazz, @NonNull Map<Class, Object> inputs, @NonNull Functions.Silencer<T> silencer) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (inputs == null) {
                throw new NullPointerException("inputs is marked non-null but is null");
            }
            if (silencer == null) {
                throw new NullPointerException("silencer is marked non-null but is null");
            }
            if (inputs.size() > 1 && !(inputs instanceof LinkedHashMap)) {
                throw new ReflectionException("Inputs must be LinkedHashMap");
            }
            try {
                Class[] classes = inputs.keySet().toArray(new Class[0]);
                Object[] args = inputs.values().toArray(new Object[0]);
                silencer.accept(ReflectionClass.createObject(clazz, classes, args), null);
            }
            catch (ReflectiveOperationException e) {
                silencer.accept((Object)null, new HiddenException(new ReflectionException("Cannot init instance of " + clazz.getName(), (Throwable)e)));
            }
            return silencer;
        }

        public static <T> T createObject(@NonNull Class<T> clazz, Class[] classes, Object[] args) throws ReflectiveOperationException {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
    }

    public static class ReflectionMethod {
        public static <T> T executeStatic(@NonNull Class<T> clazz, @NonNull String methodName, Object ... args) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (methodName == null) {
                throw new NullPointerException("methodName is marked non-null but is null");
            }
            Predicate<Method> predicate = m -> m.getReturnType().equals(clazz) && m.getName().equals(methodName);
            return ReflectionMethod.find(predicate, clazz).findFirst().map(method -> ReflectionMethod.execute(null, method, args)).orElse(null);
        }

        public static Object execute(@NonNull Object instance, @NonNull Method method) {
            if (instance == null) {
                throw new NullPointerException("instance is marked non-null but is null");
            }
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            try {
                method.setAccessible(true);
                return method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw ReflectionExecutable.handleError(method, e);
            }
        }

        public static <I, O> O execute(@NonNull Object instance, @NonNull Method method, @NonNull Class<O> outputType, @NonNull Class<I> paramType, I paramData) {
            if (instance == null) {
                throw new NullPointerException("instance is marked non-null but is null");
            }
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (outputType == null) {
                throw new NullPointerException("outputType is marked non-null but is null");
            }
            if (paramType == null) {
                throw new NullPointerException("paramType is marked non-null but is null");
            }
            return ReflectionMethod.execute(instance, method, outputType, Collections.singletonList(paramType), paramData);
        }

        public static <O> O execute(@NonNull Object instance, @NonNull Method method, @NonNull Class<O> outputType, Collection<Class<?>> inputTypes, Object ... inputData) {
            if (instance == null) {
                throw new NullPointerException("instance is marked non-null but is null");
            }
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (outputType == null) {
                throw new NullPointerException("outputType is marked non-null but is null");
            }
            if (inputTypes.size() != inputData.length) {
                throw new IllegalArgumentException("Input types does not match with input data");
            }
            if (!ReflectionMethod.validateMethod(method, outputType, inputTypes)) {
                throw new IllegalArgumentException("Given method does not match with given output type and input type");
            }
            return ReflectionMethod.execute(instance, method, inputData);
        }

        public static <O> O execute(Object instance, @NonNull Method method, Object ... args) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            try {
                method.setAccessible(true);
                return (O)method.invoke(instance, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw ReflectionExecutable.handleError(method, e);
            }
        }

        public static List<Method> find(@NonNull Class<?> clazz, Predicate<Method> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            return ReflectionMethod.find(Optional.ofNullable(predicate).orElse(method -> true), clazz).collect(Collectors.toList());
        }

        public static Stream<Method> find(@NonNull Predicate<Method> predicate, @NonNull Class<?> clazz) {
            if (predicate == null) {
                throw new NullPointerException("predicate is marked non-null but is null");
            }
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            return Stream.of(clazz.getDeclaredMethods()).filter(predicate);
        }

        public static boolean validateMethod(Method method, Class<?> outputType, Class<?> ... inputTypes) {
            return ReflectionMethod.validateMethod(method, outputType, Arrays.asList(inputTypes));
        }

        public static boolean validateMethod(@NonNull Method method, @NonNull Class<?> outputType, @NonNull Collection<Class<?>> inputTypes) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (outputType == null) {
                throw new NullPointerException("outputType is marked non-null but is null");
            }
            if (inputTypes == null) {
                throw new NullPointerException("inputTypes is marked non-null but is null");
            }
            if (!ReflectionClass.assertDataType(outputType, method.getReturnType())) {
                return false;
            }
            List inputs = inputTypes.stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (inputs.size() != method.getParameterCount()) {
                return false;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < inputs.size(); ++i) {
                if (ReflectionClass.assertDataType((Class)inputs.get(i), parameterTypes[i])) continue;
                return false;
            }
            return true;
        }

        public static class MethodInfo {
            private final Method method;
            private final Class<?> output;
            private final LinkedHashMap<String, Class<?>> params;

            public Method getMethod() {
                return this.method;
            }

            public Class<?> getOutput() {
                return this.output;
            }

            public LinkedHashMap<String, Class<?>> getParams() {
                return this.params;
            }

            public MethodInfo(Method method, Class<?> output, LinkedHashMap<String, Class<?>> params) {
                this.method = method;
                this.output = output;
                this.params = params;
            }
        }
    }

    public static class ReflectionExecutable {
        private static <T> Stream<T> scan(@NonNull Class<?> clazz, @NonNull Function<ClassInfo, Stream<T>> scanFunction) {
            ScanResult scanResult;
            ClassInfo classInfo;
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (scanFunction == null) {
                throw new NullPointerException("scanFunction is marked non-null but is null");
            }
            ClassGraph graph = new ClassGraph().enableAnnotationInfo().ignoreClassVisibility().ignoreMethodVisibility().whitelistClasses(new String[]{clazz.getName()});
            if (LOGGER.isTraceEnabled()) {
                graph.verbose();
            }
            if (Objects.isNull(classInfo = (scanResult = graph.scan()).getClassInfo(clazz.getName()))) {
                return (Stream)Stream.empty().onClose(() -> ((ScanResult)scanResult).close());
            }
            return (Stream)scanFunction.apply(classInfo).onClose(() -> ((ScanResult)scanResult).close());
        }

        public static List<Method> streamMethods(@NonNull Class<?> clazz, @NonNull Predicate<MethodInfo> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (predicate == null) {
                throw new NullPointerException("predicate is marked non-null but is null");
            }
            try (Stream stream = ReflectionExecutable.scan(clazz, classInfo -> classInfo.getMethodInfo().filter(predicate::test).stream().map(MethodInfo::loadClassAndGetMethod));){
                List<Method> list = stream.collect(Collectors.toList());
                return list;
            }
        }

        public static Stream<MethodInfo> streamConstructors(@NonNull Class<?> clazz, @NonNull Predicate<MethodInfo> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (predicate == null) {
                throw new NullPointerException("predicate is marked non-null but is null");
            }
            return ReflectionExecutable.scan(clazz, classInfo -> classInfo.getConstructorInfo().filter(predicate::test).stream());
        }

        public static boolean isBoolean(TypeSignature signature) {
            return signature instanceof BaseTypeSignature && ((BaseTypeSignature)signature).getType().equals(Boolean.TYPE);
        }

        public static boolean isVoid(TypeSignature signature) {
            return signature instanceof BaseTypeSignature && ((BaseTypeSignature)signature).getType().equals(Void.TYPE);
        }

        public static ReflectionException handleError(@NonNull Executable executable, @NonNull ReflectiveOperationException e) {
            if (executable == null) {
                throw new NullPointerException("executable is marked non-null but is null");
            }
            if (e == null) {
                throw new NullPointerException("e is marked non-null but is null");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot execute method " + executable.getName(), (Throwable)e);
            }
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (targetException instanceof ReflectionException) {
                    throw (ReflectionException)targetException;
                }
                if (Objects.nonNull(targetException)) {
                    throw new ReflectionException(targetException);
                }
            }
            throw new ReflectionException(e);
        }
    }

    public static class ReflectionField {
        public static final Predicate<Field> CONSTANT_FILTER = Reflections.hasModifiers(1, 8, 16);

        public static Stream<Field> stream(@NonNull Class<?> clazz, Predicate<Field> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            Stream<Field> stream = Stream.of(clazz.getDeclaredFields());
            if (Objects.nonNull(predicate)) {
                return stream.filter(predicate);
            }
            return stream;
        }

        public static List<Field> find(@NonNull Class<?> clazz, Predicate<Field> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            return ReflectionField.stream(clazz, predicate).collect(Collectors.toList());
        }

        public static <T> T constantByName(@NonNull Class<?> clazz, String name) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            Predicate<Field> filter = Functions.and(CONSTANT_FILTER, f -> f.getName().equals(Strings.requireNotBlank(name)));
            return ReflectionField.stream(clazz, filter).map(field -> ReflectionField.getConstant(clazz, field)).findFirst().orElse(null);
        }

        public static <T> List<T> getConstants(@NonNull Class<?> clazz, @NonNull Class<T> fieldClass) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (fieldClass == null) {
                throw new NullPointerException("fieldClass is marked non-null but is null");
            }
            return ReflectionField.streamConstants(clazz, fieldClass).collect(Collectors.toList());
        }

        public static <T> List<T> getConstants(@NonNull Class<?> clazz, @NonNull Class<T> fieldClass, Predicate<Field> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (fieldClass == null) {
                throw new NullPointerException("fieldClass is marked non-null but is null");
            }
            return ReflectionField.streamConstants(clazz, fieldClass, predicate).collect(Collectors.toList());
        }

        public static <T> Stream<T> streamConstants(@NonNull Class<T> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            return ReflectionField.streamConstants(clazz, clazz, null);
        }

        public static <T> Stream<T> streamConstants(@NonNull Class<?> clazz, @NonNull Class<T> fieldClass) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (fieldClass == null) {
                throw new NullPointerException("fieldClass is marked non-null but is null");
            }
            return ReflectionField.streamConstants(clazz, fieldClass, null);
        }

        public static <T> Stream<T> streamConstants(@NonNull Class<?> clazz, @NonNull Class<T> fieldClass, Predicate<Field> predicate) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (fieldClass == null) {
                throw new NullPointerException("fieldClass is marked non-null but is null");
            }
            Predicate<Field> filter = Functions.and(CONSTANT_FILTER, f -> ReflectionClass.assertDataType(fieldClass, f.getType()));
            if (Objects.nonNull(predicate)) {
                filter = filter.and(predicate);
            }
            return ReflectionField.stream(clazz, filter).map(field -> ReflectionField.getConstant(clazz, field));
        }

        public static <T> T getConstant(@NonNull Class<?> clazz, Field field) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            try {
                return (T)field.get(null);
            }
            catch (ClassCastException | IllegalAccessException e) {
                throw new ReflectionException(Strings.format("Failed to get field constant {0} of {1}", field.getName(), clazz.getName()), (Throwable)e);
            }
        }

        public static <T> T getConstant(@NonNull Class<?> clazz, Field field, T fallback) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            try {
                return (T)field.get(null);
            }
            catch (ClassCastException | IllegalAccessException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Failed to get field constant " + field.getName() + " of " + clazz.getName(), (Throwable)e);
                }
                return fallback;
            }
        }

        public static <T> List<T> getFieldValuesByType(@NonNull Object obj, @NonNull Class<T> searchType) {
            if (obj == null) {
                throw new NullPointerException("obj is marked non-null but is null");
            }
            if (searchType == null) {
                throw new NullPointerException("searchType is marked non-null but is null");
            }
            Predicate<Field> predicate = Functions.and(Reflections.notModifiers(8), f -> ReflectionClass.assertDataType(f.getType(), searchType));
            return ReflectionField.stream(obj.getClass(), predicate).map(f -> ReflectionField.getFieldValue(obj, f, searchType)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public static <T> T getFieldValue(@NonNull Object obj, @NonNull Field f, @NonNull Class<T> type) {
            if (obj == null) {
                throw new NullPointerException("obj is marked non-null but is null");
            }
            if (f == null) {
                throw new NullPointerException("f is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            try {
                f.setAccessible(true);
                return type.cast(f.get(obj));
            }
            catch (ClassCastException | IllegalAccessException e) {
                LOGGER.warn("Cannot get data of field " + f.getName(), (Throwable)e);
                return null;
            }
        }
    }
}

