/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import io.github.zero88.exceptions.ReflectionException;
import io.github.zero88.repl.Reflections;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public interface ReflectionMember {
    public static <T extends Member> Predicate<T> hasModifiers(int ... modifiers) {
        int searchMods = Arrays.stream(modifiers).reduce((left, right) -> left | right).orElse(0);
        return member -> (member.getModifiers() & searchMods) == searchMods;
    }

    public static <T extends Member> Predicate<T> notModifiers(int ... modifiers) {
        int searchMods = Arrays.stream(modifiers).reduce((left, right) -> left | right).orElse(0);
        return member -> (member.getModifiers() & searchMods) != searchMods;
    }

    public static <T extends Member> Predicate<T> constantPredicate() {
        return ReflectionMember.hasModifiers(1, 8, 16);
    }

    public static ReflectionException handleError(@NotNull Executable executable, @NotNull ReflectiveOperationException e) {
        if (Reflections.LOGGER.isTraceEnabled()) {
            Reflections.LOGGER.trace("Cannot execute method " + executable.getName(), (Throwable)e);
        }
        if (e instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)e).getTargetException();
            if (targetException instanceof ReflectionException) {
                throw (ReflectionException)targetException;
            }
            if (Objects.nonNull(targetException)) {
                throw new ReflectionException(targetException);
            }
        }
        throw new ReflectionException(e);
    }
}

