/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import io.github.zero88.exceptions.ReflectionException;
import io.github.zero88.repl.Arguments;
import io.github.zero88.repl.ReflectionClass;
import io.github.zero88.repl.ReflectionMember;
import io.github.zero88.repl.Reflections;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ReflectionMethod
implements ReflectionMember {
    private ReflectionMethod() {
    }

    public static <T> T executeStatic(@NotNull Class<?> declareCls, @NotNull Class<T> outputCls, @NotNull String methodName, Object ... args) {
        Predicate<Method> predicate = m -> m.getReturnType().equals(outputCls) && m.getName().equals(methodName);
        return ReflectionMethod.find(predicate, declareCls).findFirst().map(method -> ReflectionMethod.doExecute(null, method, Arguments.from(method, args))).orElse(null);
    }

    public static Object execute(@NotNull Object instance, @NotNull Method method) {
        return ReflectionMethod.execute(instance, method, new Arguments());
    }

    public static Object execute(@NotNull Object instance, @NotNull Method method, @NotNull Arguments args) {
        Arguments arguments = Arguments.from(method);
        if (!arguments.isSame(args)) {
            throw new ReflectionException("Given arguments does not match the Method signature arguments");
        }
        return ReflectionMethod.doExecute(instance, method, args);
    }

    public static <O> O execute(@NotNull Object instance, @NotNull Method method, Object ... args) {
        return (O)ReflectionMethod.doExecute(instance, method, Arguments.from(method, args));
    }

    public static <I, O> O execute(@NotNull Object instance, @NotNull Method method, @NotNull Class<O> outputType, @NotNull Class<I> argClass, I argValue) {
        return ReflectionMethod.execute(instance, method, outputType, new Arguments().put(argClass, argValue));
    }

    public static <O> O execute(@NotNull Object instance, @NotNull Method method, @NotNull Class<O> outputType, @NotNull Arguments arguments) {
        if (!ReflectionMethod.validateMethod(method, outputType, arguments)) {
            throw new IllegalArgumentException("Given method does not match with given output type and input type");
        }
        return (O)ReflectionMethod.doExecute(instance, method, arguments);
    }

    public static List<Method> find(@NotNull Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionMethod.find(predicate, clazz).collect(Collectors.toList());
    }

    public static Stream<Method> find(Predicate<Method> predicate, @NotNull Class<?> clazz) {
        return Reflections.loadScanner().methodStream(clazz, predicate);
    }

    public static boolean validateMethod(Method method, Class<?> outputType, Class<?> ... argClasses) {
        return ReflectionClass.assertDataType(outputType, method.getReturnType()) && Arguments.from(method).isSame(argClasses);
    }

    public static boolean validateMethod(@NotNull Method method, @NotNull Class<?> outputType, @NotNull Collection<Class<?>> argClasses) {
        return ReflectionMethod.validateMethod(method, outputType, argClasses.toArray(new Class[0]));
    }

    public static boolean validateMethod(@NotNull Method method, @NotNull Class<?> outputType, @NotNull Arguments arguments) {
        return ReflectionMethod.validateMethod(method, outputType, arguments.argClasses());
    }

    private static Object doExecute(Object instance, Method method, Arguments args) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, args.argValues());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw ReflectionMember.handleError(method, e);
        }
    }
}

