/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.custom.QuantityFormatException;
import io.kubernetes.client.custom.QuantityFormatter;
import java.math.BigDecimal;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class QuantityFormatterTest {
    @Test
    public void testParsePlain() {
        Quantity quantity = new QuantityFormatter().parse("1");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_SI));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
    }

    @Test
    public void testParseFractional() {
        Quantity quantity = new QuantityFormatter().parse("0.001");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_SI));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)BigDecimal.valueOf(0.001)));
    }

    @Test
    public void testParseFractionalUnit() {
        Quantity quantity = new QuantityFormatter().parse("0.001m");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_SI));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)new BigDecimal("0.000001")));
    }

    @Test
    public void testParseBinarySi() {
        Quantity quantity = new QuantityFormatter().parse("1Ki");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.BINARY_SI));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)BigDecimal.valueOf(1024L)));
    }

    @Test
    public void testParseLargeNumeratorBinarySi() {
        Quantity quantity = new QuantityFormatter().parse("32Mi");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.BINARY_SI));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)BigDecimal.valueOf(2L).pow(20).multiply(BigDecimal.valueOf(32L))));
    }

    @Test
    public void testParseExponent() {
        Quantity quantity = new QuantityFormatter().parse("1e3");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_EXPONENT));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)BigDecimal.valueOf(1000L)));
    }

    @Test
    public void testParseNegativeExponent() {
        Quantity quantity = new QuantityFormatter().parse("1e-3");
        Assert.assertThat((Object)quantity.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_EXPONENT));
        Assert.assertThat((Object)quantity.getNumber(), (Matcher)Is.is((Object)BigDecimal.valueOf(0.001)));
    }

    @Test(expected=QuantityFormatException.class)
    public void testParseBad() {
        new QuantityFormatter().parse("4e9e");
    }

    @Test
    public void testFormatPlain() {
        String formattedString = new QuantityFormatter().format(new Quantity(new BigDecimal("100"), Quantity.Format.DECIMAL_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"100"));
    }

    @Test
    public void testFormatDecimalSi() {
        String formattedString = new QuantityFormatter().format(new Quantity(new BigDecimal("100000"), Quantity.Format.DECIMAL_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"100k"));
    }

    @Test
    public void testFormatFractionalDecimalSi() {
        String formattedString = new QuantityFormatter().format(new Quantity(new BigDecimal("100.001"), Quantity.Format.DECIMAL_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"100001m"));
    }

    @Test
    public void testFormatBinarySi() {
        String formattedString = new QuantityFormatter().format(new Quantity(new BigDecimal(2).pow(20), Quantity.Format.BINARY_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"1Mi"));
    }

    @Test
    public void testFormatLessThan1024BinarySi() {
        String formattedString = new QuantityFormatter().format(new Quantity(BigDecimal.valueOf(128L), Quantity.Format.BINARY_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"128"));
    }

    @Test
    public void testFormatNon1024BinarySi() {
        String formattedString = new QuantityFormatter().format(new Quantity(BigDecimal.valueOf(2056L), Quantity.Format.BINARY_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"2056"));
    }

    @Test
    public void testFormatFractionalBinarySi() {
        String formattedString = new QuantityFormatter().format(new Quantity(BigDecimal.valueOf(123.123), Quantity.Format.BINARY_SI));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"123123m"));
    }

    @Test
    public void testFormatDecimalExponent() {
        String formattedString = new QuantityFormatter().format(new Quantity(BigDecimal.valueOf(1000000L), Quantity.Format.DECIMAL_EXPONENT));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"1e6"));
    }

    @Test
    public void testFormatEnforceExpOf3DecimalExponent() {
        String formattedString = new QuantityFormatter().format(new Quantity(BigDecimal.valueOf(100000L), Quantity.Format.DECIMAL_EXPONENT));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"100e3"));
    }

    @Test
    public void testFormatNoExpDecimalExponent() {
        String formattedString = new QuantityFormatter().format(new Quantity(BigDecimal.valueOf(12345L), Quantity.Format.DECIMAL_EXPONENT));
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"12345"));
    }
}

