/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import com.google.common.io.ByteStreams;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.Exec;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExecExample {
    public static void main(String[] args) throws IOException, ApiException, InterruptedException {
        String[] stringArray;
        boolean tty;
        String podName = "nginx-4217019353-k5sn9";
        String namespace = "default";
        ArrayList<String> commands = new ArrayList<String>();
        int len = args.length;
        if (len >= 1) {
            podName = args[0];
        }
        if (len >= 2) {
            namespace = args[1];
        }
        for (int i = 2; i < len; ++i) {
            commands.add(args[i]);
        }
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        Exec exec = new Exec();
        boolean bl = tty = System.console() != null;
        if (commands.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "sh";
        } else {
            stringArray = commands.toArray(new String[commands.size()]);
        }
        final Process proc = exec.exec(namespace, podName, stringArray, true, tty);
        Thread in = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)System.in, (OutputStream)proc.getOutputStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        in.start();
        Thread out = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)proc.getInputStream(), (OutputStream)System.out);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        out.start();
        proc.waitFor();
        out.join();
        proc.destroy();
        System.exit(proc.exitValue());
    }
}

