/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.ExtensionsV1beta1Api;
import io.kubernetes.client.models.ExtensionsV1beta1Deployment;
import io.kubernetes.client.util.ClientBuilder;
import java.io.IOException;
import java.util.ArrayList;

public class PatchExample {
    static String jsonPatchStr = "{\"op\":\"replace\",\"path\":\"/spec/template/spec/terminationGracePeriodSeconds\",\"value\":27}";
    static String jsonDepStr = "{\"kind\":\"Deployment\",\"apiVersion\":\"extensions/v1beta1\",\"metadata\":{\"name\":\"hello-node\",\"creationTimestamp\":null,\"labels\":{\"run\":\"hello-node\"}},\"spec\":{\"replicas\":1,\"selector\":{\"matchLabels\":{\"run\":\"hello-node\"}},\"template\":{\"metadata\":{\"creationTimestamp\":null,\"labels\":{\"run\":\"hello-node\"}},\"spec\":{\"terminationGracePeriodSeconds\":30,\"containers\":[{\"name\":\"hello-node\",\"image\":\"hello-node:v1\",\"ports\":[{\"containerPort\":8080}],\"resources\":{}}]}},\"strategy\":{}},\"status\":{}}";

    public static void main(String[] args) throws IOException, ApiException {
        PatchExample example = new PatchExample();
        ApiClient client = ClientBuilder.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        ExtensionsV1beta1Deployment body = (ExtensionsV1beta1Deployment)example.deserialize(jsonDepStr, ExtensionsV1beta1Deployment.class);
        ExtensionsV1beta1Deployment deploy1 = example.createDeployment("default", body, "false");
        System.out.println("original deployment" + deploy1);
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        arr.add(((JsonElement)example.deserialize(jsonPatchStr, JsonElement.class)).getAsJsonObject());
        ExtensionsV1beta1Deployment deploy2 = example.PatchDeployment("hello-node", "default", arr, "false");
        System.out.println("patched deployment" + deploy2);
    }

    public ExtensionsV1beta1Deployment createDeployment(String namespace, ExtensionsV1beta1Deployment body, String pretty) throws ApiException {
        ExtensionsV1beta1Api api = new ExtensionsV1beta1Api();
        ExtensionsV1beta1Deployment deploy = api.createNamespacedDeployment(namespace, body, pretty);
        return deploy;
    }

    public ExtensionsV1beta1Deployment PatchDeployment(String deployName, String namespace, Object body, String pretty) throws ApiException {
        ExtensionsV1beta1Api api = new ExtensionsV1beta1Api();
        ExtensionsV1beta1Deployment deploy = api.patchNamespacedDeployment(deployName, namespace, body, pretty);
        return deploy;
    }

    public Object deserialize(String jsonStr, Class<?> targetClass) {
        Object obj = new Gson().fromJson(jsonStr, targetClass);
        return obj;
    }
}

