/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.rx;

import io.objectbox.query.Query;
import io.objectbox.reactive.DataSubscription;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.List;

public abstract class RxQuery {
    public static <T> Flowable<T> flowableOneByOne(Query<T> query) {
        return RxQuery.flowableOneByOne(query, BackpressureStrategy.BUFFER);
    }

    public static <T> Flowable<T> flowableOneByOne(Query<T> query, BackpressureStrategy strategy) {
        return Flowable.create(emitter -> RxQuery.createListItemEmitter(query, emitter), (BackpressureStrategy)strategy);
    }

    static <T> void createListItemEmitter(Query<T> query, FlowableEmitter<T> emitter) {
        DataSubscription dataSubscription = query.subscribe().observer(data -> {
            for (Object datum : data) {
                if (emitter.isCancelled()) {
                    return;
                }
                emitter.onNext(datum);
            }
            if (!emitter.isCancelled()) {
                emitter.onComplete();
            }
        });
        emitter.setCancellable(() -> ((DataSubscription)dataSubscription).cancel());
    }

    public static <T> Observable<List<T>> observable(Query<T> query) {
        return Observable.create(emitter -> {
            DataSubscription dataSubscription = query.subscribe().observer(data -> {
                if (!emitter.isDisposed()) {
                    emitter.onNext(data);
                }
            });
            emitter.setCancellable(() -> ((DataSubscription)dataSubscription).cancel());
        });
    }

    public static <T> Single<List<T>> single(Query<T> query) {
        return Single.create(emitter -> query.subscribe().single().observer(data -> {
            if (!emitter.isDisposed()) {
                emitter.onSuccess(data);
            }
        }));
    }
}

