/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.test;

import io.reactivesocket.Payload;
import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.ReactiveSocketClient;
import io.reactivesocket.util.PayloadImpl;
import java.time.Duration;
import org.HdrHistogram.Recorder;
import reactor.core.publisher.Flux;

public class PingClient {
    private final Payload payload;
    private final ReactiveSocketClient client;
    private ReactiveSocket reactiveSocket;

    public PingClient(ReactiveSocketClient client) {
        this.client = client;
        this.payload = new PayloadImpl("hello");
    }

    public PingClient connect() {
        if (null == this.reactiveSocket) {
            this.reactiveSocket = (ReactiveSocket)this.client.connect().block();
        }
        return this;
    }

    public Recorder startTracker(Duration interval) {
        Recorder histogram = new Recorder(3600000000000L, 3);
        Flux.interval((Duration)interval).doOnNext(aLong -> {
            System.out.println("---- PING/ PONG HISTO ----");
            histogram.getIntervalHistogram().outputPercentileDistribution(System.out, 5, Double.valueOf(1000.0), false);
            System.out.println("---- PING/ PONG HISTO ----");
        }).subscribe();
        return histogram;
    }

    public Flux<Payload> startPingPong(int count, Recorder histogram) {
        this.connect();
        return Flux.range((int)1, (int)count).flatMap(i -> {
            long start = System.nanoTime();
            return this.reactiveSocket.requestResponse(this.payload).doFinally(signalType -> {
                long diff = System.nanoTime() - start;
                histogram.recordValue(diff);
            });
        }).doOnError(Throwable::printStackTrace);
    }
}

