/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Subscription;
import rx.functions.Func1;
import rx.internal.util.IndexedRingBuffer;

public final class SubscriptionIndexedRingBuffer<T extends Subscription>
implements Subscription {
    private volatile IndexedRingBuffer<T> subscriptions = IndexedRingBuffer.getInstance();
    private volatile int unsubscribed = 0;
    private static final AtomicIntegerFieldUpdater<SubscriptionIndexedRingBuffer> UNSUBSCRIBED = AtomicIntegerFieldUpdater.newUpdater(SubscriptionIndexedRingBuffer.class, "unsubscribed");
    private static final Func1<Subscription, Boolean> UNSUBSCRIBE = new Func1<Subscription, Boolean>(){

        @Override
        public Boolean call(Subscription s) {
            s.unsubscribe();
            return Boolean.TRUE;
        }
    };

    public SubscriptionIndexedRingBuffer() {
    }

    public SubscriptionIndexedRingBuffer(T ... subscriptions) {
        for (T t : subscriptions) {
            this.subscriptions.add(t);
        }
    }

    @Override
    public boolean isUnsubscribed() {
        return this.unsubscribed == 1;
    }

    public synchronized int add(T s) {
        if (this.unsubscribed == 1 || this.subscriptions == null) {
            s.unsubscribe();
            return -1;
        }
        int n = this.subscriptions.add(s);
        if (this.unsubscribed == 1) {
            s.unsubscribe();
        }
        return n;
    }

    public void remove(int n) {
        if (this.unsubscribed == 1 || this.subscriptions == null || n < 0) {
            return;
        }
        Subscription t = (Subscription)this.subscriptions.remove(n);
        if (t != null && t != null) {
            t.unsubscribe();
        }
    }

    public void removeSilently(int n) {
        if (this.unsubscribed == 1 || this.subscriptions == null || n < 0) {
            return;
        }
        this.subscriptions.remove(n);
    }

    @Override
    public void unsubscribe() {
        if (UNSUBSCRIBED.compareAndSet(this, 0, 1) && this.subscriptions != null) {
            SubscriptionIndexedRingBuffer.unsubscribeFromAll(this.subscriptions);
            IndexedRingBuffer<T> s = this.subscriptions;
            this.subscriptions = null;
            s.unsubscribe();
        }
    }

    public int forEach(Func1<T, Boolean> action) {
        return this.forEach(action, 0);
    }

    public synchronized int forEach(Func1<T, Boolean> action, int startIndex) {
        if (this.unsubscribed == 1 || this.subscriptions == null) {
            return 0;
        }
        return this.subscriptions.forEach(action, startIndex);
    }

    private static void unsubscribeFromAll(IndexedRingBuffer<? extends Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        subscriptions.forEach(UNSUBSCRIBE);
    }
}

