/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.schedulers.TestScheduler;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class TestSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> state;
    private final Scheduler.Worker innerScheduler;

    public static <T> TestSubject<T> create(TestScheduler scheduler) {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.get(), state.nl);
            }
        };
        state.onTerminated = state.onAdded;
        return new TestSubject(state, state, scheduler);
    }

    protected TestSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state, TestScheduler scheduler) {
        super(onSubscribe);
        this.state = state;
        this.innerScheduler = scheduler.createWorker();
    }

    @Override
    public void onCompleted() {
        this.onCompleted(this.innerScheduler.now());
    }

    private void _onCompleted() {
        if (this.state.active) {
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(NotificationLite.instance().completed())) {
                bo.onCompleted();
            }
        }
    }

    public void onCompleted(long timeInMilliseconds) {
        this.innerScheduler.schedule(new Action0(){

            @Override
            public void call() {
                TestSubject.this._onCompleted();
            }
        }, timeInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onError(Throwable e) {
        this.onError(e, this.innerScheduler.now());
    }

    private void _onError(Throwable e) {
        if (this.state.active) {
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(NotificationLite.instance().error(e))) {
                bo.onError(e);
            }
        }
    }

    public void onError(final Throwable e, long timeInMilliseconds) {
        this.innerScheduler.schedule(new Action0(){

            @Override
            public void call() {
                TestSubject.this._onError(e);
            }
        }, timeInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onNext(T v) {
        this.onNext(v, this.innerScheduler.now());
    }

    private void _onNext(T v) {
        for (SubjectSubscriptionManager.SubjectObserver<T> o : this.state.observers()) {
            o.onNext(v);
        }
    }

    public void onNext(final T v, long timeInMilliseconds) {
        this.innerScheduler.schedule(new Action0(){

            @Override
            public void call() {
                TestSubject.this._onNext(v);
            }
        }, timeInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }
}

