/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func1;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observers.SerializedObserver;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorWindowWithStartEndObservable<T, U, V>
implements Observable.Operator<Observable<T>, T> {
    final Observable<? extends U> windowOpenings;
    final Func1<? super U, ? extends Observable<? extends V>> windowClosingSelector;

    public OperatorWindowWithStartEndObservable(Observable<? extends U> windowOpenings, Func1<? super U, ? extends Observable<? extends V>> windowClosingSelector) {
        this.windowOpenings = windowOpenings;
        this.windowClosingSelector = windowClosingSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        final SourceSubscriber sub = new SourceSubscriber(child);
        Subscriber open = new Subscriber<U>(child){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(U t) {
                sub.beginWindow(t);
            }

            @Override
            public void onError(Throwable e) {
                sub.onError(e);
            }

            @Override
            public void onCompleted() {
                sub.onCompleted();
            }
        };
        this.windowOpenings.unsafeSubscribe(open);
        return sub;
    }

    final class SourceSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final CompositeSubscription csub;
        final Object guard;
        final List<SerializedSubject<T>> chunks;
        boolean done;

        public SourceSubscriber(Subscriber<? super Observable<T>> child) {
            super(child);
            this.child = new SerializedSubscriber(child);
            this.guard = new Object();
            this.chunks = new LinkedList();
            this.csub = new CompositeSubscription();
            child.add(this.csub);
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            ArrayList list;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                list = new ArrayList(this.chunks);
            }
            for (SerializedSubject serializedSubject : list) {
                serializedSubject.consumer.onNext(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            ArrayList list;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                this.done = true;
                list = new ArrayList(this.chunks);
                this.chunks.clear();
            }
            for (SerializedSubject serializedSubject : list) {
                serializedSubject.consumer.onError(e);
            }
            this.child.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            ArrayList list;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                this.done = true;
                list = new ArrayList(this.chunks);
                this.chunks.clear();
            }
            for (SerializedSubject serializedSubject : list) {
                serializedSubject.consumer.onCompleted();
            }
            this.child.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginWindow(U token) {
            Observable end;
            final SerializedSubject s = this.createSerializedSubject();
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                this.chunks.add(s);
            }
            this.child.onNext(s.producer);
            try {
                end = OperatorWindowWithStartEndObservable.this.windowClosingSelector.call(token);
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
            Subscriber v = new Subscriber<V>(){
                boolean once = true;

                @Override
                public void onNext(V t) {
                    this.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onCompleted() {
                    if (this.once) {
                        this.once = false;
                        SourceSubscriber.this.endWindow(s);
                        SourceSubscriber.this.csub.remove(this);
                    }
                }
            };
            this.csub.add(v);
            end.unsafeSubscribe(v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endWindow(SerializedSubject<T> window) {
            boolean terminate = false;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                Iterator it = this.chunks.iterator();
                while (it.hasNext()) {
                    SerializedSubject s = it.next();
                    if (s != window) continue;
                    terminate = true;
                    it.remove();
                    break;
                }
            }
            if (terminate) {
                window.consumer.onCompleted();
            }
        }

        SerializedSubject<T> createSerializedSubject() {
            BufferUntilSubscriber bus = BufferUntilSubscriber.create();
            return new SerializedSubject(bus, bus);
        }
    }

    static final class SerializedSubject<T> {
        final Observer<T> consumer;
        final Observable<T> producer;

        public SerializedSubject(Observer<T> consumer, Observable<T> producer) {
            this.consumer = new SerializedObserver<T>(consumer);
            this.producer = producer;
        }
    }
}

