/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action1;

public final class SubscriptionRandomList<T extends Subscription>
implements Subscription {
    private Set<T> subscriptions;
    private boolean unsubscribed = false;

    public SubscriptionRandomList() {
    }

    public SubscriptionRandomList(T ... subscriptions) {
        this.subscriptions = new HashSet<T>(Arrays.asList(subscriptions));
    }

    @Override
    public synchronized boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T s) {
        Subscription unsubscribe = null;
        SubscriptionRandomList subscriptionRandomList = this;
        synchronized (subscriptionRandomList) {
            if (this.unsubscribed) {
                unsubscribe = (Subscription)s;
            } else {
                if (this.subscriptions == null) {
                    this.subscriptions = new HashSet<T>(4);
                }
                this.subscriptions.add(s);
            }
        }
        if (unsubscribe != null) {
            unsubscribe.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Subscription s) {
        boolean unsubscribe = false;
        SubscriptionRandomList subscriptionRandomList = this;
        synchronized (subscriptionRandomList) {
            if (this.unsubscribed || this.subscriptions == null) {
                return;
            }
            unsubscribe = this.subscriptions.remove(s);
        }
        if (unsubscribe) {
            s.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<T> unsubscribe = null;
        SubscriptionRandomList subscriptionRandomList = this;
        synchronized (subscriptionRandomList) {
            if (this.unsubscribed || this.subscriptions == null) {
                return;
            }
            unsubscribe = this.subscriptions;
            this.subscriptions = null;
        }
        SubscriptionRandomList.unsubscribeFromAll(unsubscribe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Action1<T> action) {
        Subscription[] ss = null;
        SubscriptionRandomList subscriptionRandomList = this;
        synchronized (subscriptionRandomList) {
            if (this.unsubscribed || this.subscriptions == null) {
                return;
            }
            ss = (Subscription[])this.subscriptions.toArray(ss);
        }
        for (Subscription t : ss) {
            action.call(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        Set<T> unsubscribe = null;
        SubscriptionRandomList subscriptionRandomList = this;
        synchronized (subscriptionRandomList) {
            if (this.unsubscribed) {
                return;
            }
            this.unsubscribed = true;
            unsubscribe = this.subscriptions;
            this.subscriptions = null;
        }
        SubscriptionRandomList.unsubscribeFromAll(unsubscribe);
    }

    private static <T extends Subscription> void unsubscribeFromAll(Collection<T> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        Exceptions.throwIfAny(es);
    }
}

