/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMergeMaxConcurrent<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final int maxConcurrency;

    public OperatorMergeMaxConcurrent(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        SourceSubscriber<? super T> ssub = new SourceSubscriber<T>(this.maxConcurrency, s, csub);
        child.setProducer(new MergeMaxConcurrentProducer<T>(ssub));
        return ssub;
    }

    static final class SourceSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final NotificationLite<T> nl = NotificationLite.instance();
        final int maxConcurrency;
        final Subscriber<T> s;
        final CompositeSubscription csub;
        final Object guard;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SourceSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(SourceSubscriber.class, "wip");
        volatile int sourceIndex;
        static final AtomicIntegerFieldUpdater<SourceSubscriber> SOURCE_INDEX = AtomicIntegerFieldUpdater.newUpdater(SourceSubscriber.class, "sourceIndex");
        int active;
        final Queue<Observable<? extends T>> queue;
        boolean emitting;
        int missedEmitting;
        int lastIndex;
        final List<MergeItemSubscriber> subscribers;
        volatile long requested;
        static final AtomicLongFieldUpdater<SourceSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(SourceSubscriber.class, "requested");

        public SourceSubscriber(int maxConcurrency, Subscriber<T> s, CompositeSubscription csub) {
            super(s);
            this.maxConcurrency = maxConcurrency;
            this.s = s;
            this.csub = csub;
            this.guard = new Object();
            this.queue = new ArrayDeque<Observable<? extends T>>(maxConcurrency);
            this.subscribers = Collections.synchronizedList(new ArrayList());
            this.wip = 1;
        }

        @Override
        public void onStart() {
            this.request(this.maxConcurrency);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            Object object = this.guard;
            synchronized (object) {
                this.queue.add(t);
            }
            this.subscribeNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeNext() {
            Observable<T> t;
            Object object = this.guard;
            synchronized (object) {
                t = this.queue.peek();
                if (t == null || this.active >= this.maxConcurrency) {
                    return;
                }
                ++this.active;
                this.queue.poll();
            }
            MergeItemSubscriber itemSub = new MergeItemSubscriber(SOURCE_INDEX.getAndIncrement(this));
            this.subscribers.add(itemSub);
            this.csub.add(itemSub);
            WIP.incrementAndGet(this);
            t.unsafeSubscribe(itemSub);
            this.request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object[] active;
            List<MergeItemSubscriber> list = this.subscribers;
            synchronized (list) {
                active = this.subscribers.toArray();
                this.subscribers.clear();
            }
            try {
                this.s.onError(e);
                this.unsubscribe();
            }
            finally {
                for (Object o : active) {
                    MergeItemSubscriber a = (MergeItemSubscriber)o;
                    a.release();
                }
            }
        }

        @Override
        public void onCompleted() {
            WIP.decrementAndGet(this);
            this.drain();
        }

        protected void downstreamRequest(long n) {
            long u;
            long r;
            while (!REQUESTED.compareAndSet(this, r, u = (r = this.requested) != Long.MAX_VALUE && n == Long.MAX_VALUE ? Long.MAX_VALUE : (r + n < 0L ? Long.MAX_VALUE : r + n))) {
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drain() {
            SourceSubscriber sourceSubscriber = this;
            synchronized (sourceSubscriber) {
                if (this.emitting) {
                    ++this.missedEmitting;
                    return;
                }
                this.emitting = true;
                this.missedEmitting = 0;
            }
            List<MergeItemSubscriber> subs = this.subscribers;
            Subscriber<T> child = this.s;
            Object[] active = new Object[subs.size()];
            block12: while (true) {
                block25: {
                    long r;
                    if ((r = this.requested) > 0L) {
                        Object e;
                        int idx = this.lastIndex;
                        List<MergeItemSubscriber> list = subs;
                        synchronized (list) {
                            active = subs.size() == active.length ? subs.toArray(active) : subs.toArray();
                        }
                        int resumeIndex = 0;
                        int j = 0;
                        for (Object o : active) {
                            e = (MergeItemSubscriber)o;
                            if (((MergeItemSubscriber)e).index == idx) {
                                resumeIndex = j;
                                break;
                            }
                            ++j;
                        }
                        int sumConsumed = 0;
                        for (int i = 0; i < active.length; ++i) {
                            Object v;
                            j = (i + resumeIndex) % active.length;
                            MergeItemSubscriber e2 = (MergeItemSubscriber)active[j];
                            RxRingBuffer b = e2.buffer;
                            this.lastIndex = e2.index;
                            if (!e2.once && b.peek() == null) {
                                subs.remove(e2);
                                e = this.guard;
                                synchronized (e) {
                                    --this.active;
                                }
                                this.csub.remove(e2);
                                e2.release();
                                this.subscribeNext();
                                WIP.decrementAndGet(this);
                                continue block12;
                            }
                            int consumed = 0;
                            while (r > 0L && (v = b.poll()) != null) {
                                this.nl.accept(child, v);
                                if (child.isUnsubscribed()) {
                                    return;
                                }
                                --r;
                                ++consumed;
                            }
                            if (consumed > 0) {
                                sumConsumed += consumed;
                                REQUESTED.addAndGet(this, -consumed);
                                e2.requestMore(consumed);
                            }
                            if (r != 0L) {
                                continue;
                            }
                            break block25;
                        }
                        if (sumConsumed != 0) continue;
                    }
                }
                if (active.length == 0 && this.wip == 0) {
                    child.onCompleted();
                    return;
                }
                SourceSubscriber sourceSubscriber2 = this;
                synchronized (sourceSubscriber2) {
                    if (this.missedEmitting == 0) {
                        this.emitting = false;
                        break;
                    }
                    this.missedEmitting = 0;
                }
            }
        }

        final class MergeItemSubscriber
        extends Subscriber<T> {
            volatile boolean once = true;
            final int index;
            final RxRingBuffer buffer = RxRingBuffer.getSpmcInstance();

            public MergeItemSubscriber(int index) {
                this.index = index;
            }

            @Override
            public void onStart() {
                this.request(RxRingBuffer.SIZE);
            }

            @Override
            public void onNext(T t) {
                try {
                    this.buffer.onNext(t);
                }
                catch (MissingBackpressureException ex) {
                    this.onError(ex);
                    return;
                }
                SourceSubscriber.this.drain();
            }

            @Override
            public void onError(Throwable e) {
                SourceSubscriber.this.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.once) {
                    this.once = false;
                    SourceSubscriber.this.drain();
                }
            }

            void requestMore(long n) {
                this.request(n);
            }

            void release() {
                this.buffer.release();
            }
        }
    }

    static final class MergeMaxConcurrentProducer<T>
    implements Producer {
        final SourceSubscriber<T> ssub;

        public MergeMaxConcurrentProducer(SourceSubscriber<T> ssub) {
            this.ssub = ssub;
        }

        @Override
        public void request(long n) {
            this.ssub.downstreamRequest(n);
        }
    }
}

