/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public ObservableFlatMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super U> t) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, t, this.mapper)) {
            return;
        }
        this.source.subscribe(new MergeObserver<T, U>(t, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    static final class InnerObserver<T, U>
    extends AtomicReference<Disposable>
    implements Observer<U> {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeObserver<T, U> parent;
        volatile boolean done;
        volatile SimpleQueue<U> queue;
        int fusionMode;

        InnerObserver(MergeObserver<T, U> parent, long id) {
            this.id = id;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.setOnce(this, s) && s instanceof QueueDisposable) {
                QueueDisposable qd = (QueueDisposable)s;
                int m = qd.requestFusion(7);
                if (m == 1) {
                    this.fusionMode = m;
                    this.queue = qd;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m == 2) {
                    this.fusionMode = m;
                    this.queue = qd;
                }
            }
        }

        @Override
        public void onNext(U t) {
            if (this.fusionMode == 0) {
                this.parent.tryEmit(t, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.parent.errors.addThrowable(t)) {
                if (!this.parent.delayErrors) {
                    this.parent.disposeAll();
                }
                this.done = true;
                this.parent.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class MergeObserver<T, U>
    extends AtomicInteger
    implements Disposable,
    Observer<T> {
        private static final long serialVersionUID = -2117620485640801370L;
        final Observer<? super U> actual;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimplePlainQueue<U> queue;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        volatile boolean cancelled;
        final AtomicReference<InnerObserver<?, ?>[]> observers;
        static final InnerObserver<?, ?>[] EMPTY = new InnerObserver[0];
        static final InnerObserver<?, ?>[] CANCELLED = new InnerObserver[0];
        Disposable s;
        long uniqueId;
        long lastId;
        int lastIndex;
        Queue<ObservableSource<? extends U>> sources;
        int wip;

        MergeObserver(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            if (maxConcurrency != Integer.MAX_VALUE) {
                this.sources = new ArrayDeque<ObservableSource<? extends U>>(maxConcurrency);
            }
            this.observers = new AtomicReference<InnerObserver<?, ?>[]>(EMPTY);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            ObservableSource<? extends U> p;
            if (this.done) {
                return;
            }
            try {
                p = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null ObservableSource");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            if (this.maxConcurrency != Integer.MAX_VALUE) {
                MergeObserver mergeObserver = this;
                synchronized (mergeObserver) {
                    if (this.wip == this.maxConcurrency) {
                        this.sources.offer(p);
                        return;
                    }
                    ++this.wip;
                }
            }
            this.subscribeInner(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeInner(ObservableSource<? extends U> p) {
            block5: {
                InnerObserver inner;
                while (p instanceof Callable) {
                    this.tryEmitScalar((Callable)((Object)p));
                    if (this.maxConcurrency == Integer.MAX_VALUE) break block5;
                    MergeObserver mergeObserver = this;
                    synchronized (mergeObserver) {
                        p = this.sources.poll();
                        if (p == null) {
                            --this.wip;
                            break block5;
                        }
                    }
                }
                if (!this.addInner(inner = new InnerObserver(this, this.uniqueId++))) break block5;
                p.subscribe(inner);
            }
        }

        boolean addInner(InnerObserver<T, U> inner) {
            InnerObserver[] b;
            InnerObserver<?, ?>[] a;
            do {
                if ((a = this.observers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n = a.length;
                b = new InnerObserver[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
            } while (!this.observers.compareAndSet(a, b));
            return true;
        }

        void removeInner(InnerObserver<T, U> inner) {
            InnerObserver<?, ?>[] b;
            InnerObserver<?, ?>[] a;
            do {
                int n;
                if ((n = (a = this.observers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new InnerObserver[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.observers.compareAndSet(a, b));
        }

        void tryEmitScalar(Callable<? extends U> value) {
            U u;
            try {
                u = value.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.errors.addThrowable(ex);
                this.drain();
                return;
            }
            if (u == null) {
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.actual.onNext(u);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<U> q = this.queue;
                if (q == null) {
                    q = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                    this.queue = q;
                }
                if (!q.offer(u)) {
                    this.onError(new IllegalStateException("Scalar queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void tryEmit(U value, InnerObserver<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.actual.onNext(value);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue q = inner.queue;
                if (q == null) {
                    q = new SpscLinkedArrayQueue(this.bufferSize);
                    inner.queue = q;
                }
                q.offer(value);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            if (this.errors.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                Throwable ex;
                this.cancelled = true;
                if (this.disposeAll() && (ex = this.errors.terminate()) != null && ex != ExceptionHelper.TERMINATED) {
                    RxJavaPlugins.onError(ex);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drainLoop() {
            Observer<U> child = this.actual;
            int missed = 1;
            while (true) {
                if (this.checkTerminate()) {
                    return;
                }
                SimplePlainQueue<U> svq = this.queue;
                if (svq != null) {
                    while (true) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        U o = svq.poll();
                        if (o != null) {
                            child.onNext(o);
                            continue;
                        }
                        if (o == null) break;
                    }
                }
                boolean d = this.done;
                svq = this.queue;
                InnerObserver<?, ?>[] inner = this.observers.get();
                int n = inner.length;
                if (d && (svq == null || svq.isEmpty()) && n == 0) {
                    Throwable ex = (Throwable)this.errors.get();
                    if (ex == null) {
                        child.onComplete();
                    } else {
                        child.onError(this.errors.terminate());
                    }
                    return;
                }
                boolean innerCompleted = false;
                if (n != 0) {
                    int i;
                    int j;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n <= index || inner[index].id != startId) {
                        if (n <= index) {
                            index = 0;
                        }
                        j = index;
                        for (i = 0; i < n && inner[j].id != startId; ++i) {
                            if (++j != n) continue;
                            j = 0;
                        }
                        index = j;
                        this.lastIndex = j;
                        this.lastId = inner[j].id;
                    }
                    j = index;
                    block8: for (i = 0; i < n; ++i) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerObserver<?, ?> is = inner[j];
                        Object o = null;
                        block9: do {
                            if (this.checkTerminate()) {
                                return;
                            }
                            SimpleQueue q = is.queue;
                            if (q == null) break;
                            do {
                                try {
                                    o = q.poll();
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal(ex);
                                    is.dispose();
                                    this.errors.addThrowable(ex);
                                    if (this.checkTerminate()) {
                                        return;
                                    }
                                    this.removeInner(is);
                                    innerCompleted = true;
                                    ++i;
                                    continue block8;
                                }
                                if (o == null) continue block9;
                                child.onNext(o);
                            } while (!this.checkTerminate());
                            return;
                        } while (o != null);
                        boolean innerDone = is.done;
                        SimpleQueue innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            if (this.checkTerminate()) {
                                return;
                            }
                            innerCompleted = true;
                        }
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                    this.lastId = inner[j].id;
                }
                if (innerCompleted) {
                    ObservableSource<? extends U> p;
                    if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                    MergeObserver mergeObserver = this;
                    synchronized (mergeObserver) {
                        p = this.sources.poll();
                        if (p == null) {
                            --this.wip;
                            continue;
                        }
                    }
                    this.subscribeInner(p);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        boolean checkTerminate() {
            if (this.cancelled) {
                return true;
            }
            Throwable e = (Throwable)this.errors.get();
            if (!this.delayErrors && e != null) {
                this.disposeAll();
                this.actual.onError(this.errors.terminate());
                return true;
            }
            return false;
        }

        boolean disposeAll() {
            this.s.dispose();
            InnerObserver<?, ?>[] a = this.observers.get();
            if (a != CANCELLED && (a = this.observers.getAndSet(CANCELLED)) != CANCELLED) {
                for (InnerObserver<?, ?> inner : a) {
                    inner.dispose();
                }
                return true;
            }
            return false;
        }
    }
}

