/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapMaybe<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final boolean delayErrors;

    public ObservableFlatMapMaybe(ObservableSource<T> source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayError) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayError;
    }

    @Override
    protected void subscribeActual(Observer<? super R> s) {
        this.source.subscribe(new FlatMapMaybeObserver<T, R>(s, this.mapper, this.delayErrors));
    }

    static final class FlatMapMaybeObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 8600231336733376951L;
        final Observer<? super R> actual;
        final boolean delayErrors;
        final CompositeDisposable set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final AtomicReference<SpscLinkedArrayQueue<R>> queue;
        Disposable d;
        volatile boolean cancelled;

        FlatMapMaybeObserver(Observer<? super R> actual, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            MaybeSource<R> ms;
            try {
                ms = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.d.dispose();
                this.onError(ex);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (this.set.add(inner)) {
                ms.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.active.decrementAndGet();
            if (this.errors.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.d.dispose();
            this.set.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.actual.onNext(value);
                boolean d = this.active.decrementAndGet() == 0;
                SpscLinkedArrayQueue<R> q = this.queue.get();
                if (d && (q == null || q.isEmpty())) {
                    Throwable ex = this.errors.terminate();
                    if (ex != null) {
                        this.actual.onError(ex);
                    } else {
                        this.actual.onComplete();
                    }
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SpscLinkedArrayQueue<R> q;
                SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q = this.getOrCreateQueue();
                synchronized (spscLinkedArrayQueue) {
                    q.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SpscLinkedArrayQueue<R> getOrCreateQueue() {
            SpscLinkedArrayQueue<Object> current;
            do {
                if ((current = this.queue.get()) == null) continue;
                return current;
            } while (!this.queue.compareAndSet(null, current = new SpscLinkedArrayQueue(Observable.bufferSize())));
            return current;
        }

        void innerError(InnerObserver inner, Throwable e) {
            this.set.delete(inner);
            if (this.errors.addThrowable(e)) {
                if (!this.delayErrors) {
                    this.d.dispose();
                    this.set.dispose();
                }
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void innerComplete(InnerObserver inner) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                boolean d = this.active.decrementAndGet() == 0;
                SpscLinkedArrayQueue<R> q = this.queue.get();
                if (d && (q == null || q.isEmpty())) {
                    Throwable ex = this.errors.terminate();
                    if (ex != null) {
                        this.actual.onError(ex);
                    } else {
                        this.actual.onComplete();
                    }
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
                this.drainLoop();
            } else {
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            SpscLinkedArrayQueue<R> q = this.queue.get();
            if (q != null) {
                q.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            Observer<R> a = this.actual;
            AtomicInteger n = this.active;
            AtomicReference<SpscLinkedArrayQueue<R>> qr = this.queue;
            while (true) {
                boolean empty;
                Throwable ex;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                    ex = this.errors.terminate();
                    this.clear();
                    a.onError(ex);
                    return;
                }
                boolean d = n.get() == 0;
                SpscLinkedArrayQueue<R> q = qr.get();
                Object v = q != null ? (Object)q.poll() : null;
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex2 = this.errors.terminate();
                    if (ex2 != null) {
                        a.onError(ex2);
                    } else {
                        a.onComplete();
                    }
                    return;
                }
                if (!empty) {
                    a.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements MaybeObserver<R>,
        Disposable {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapMaybeObserver.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapMaybeObserver.this.innerError(this, e);
            }

            @Override
            public void onComplete() {
                FlatMapMaybeObserver.this.innerComplete(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

