/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor.writer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CodeWriter
extends PrintWriter {
    private int indentSize = 2;
    private int indent = 0;
    private boolean first = true;

    public CodeWriter(Writer out) {
        super(out);
    }

    public Writer writer() {
        return this.out;
    }

    public int indentSize() {
        return this.indentSize;
    }

    public CodeWriter indentSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.indentSize = size;
        return this;
    }

    public String indentation() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent * this.indentSize; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public CodeWriter indent() {
        ++this.indent;
        return this;
    }

    public CodeWriter unindent() {
        if (this.indent == 0) {
            throw new IllegalStateException();
        }
        --this.indent;
        return this;
    }

    public CodeWriter indented(Runnable block) {
        this.indent();
        block.run();
        this.unindent();
        return this;
    }

    public CodeWriter javaImport(String name) {
        return this.append("import ").append(name).append(";").newLine();
    }

    public CodeWriter code(String string) {
        if (!this.first) {
            this.println();
        }
        this.print(string);
        return this;
    }

    public CodeWriter codeln(String line) {
        return this.code(line).newLine();
    }

    public CodeWriter stmt(String statement) {
        return this.code(statement).append(";").newLine();
    }

    public CodeWriter newLine() {
        this.println();
        return this;
    }

    public CodeWriter writeSeq(Stream<String> sequence, String delimiter) {
        return this.append(sequence.collect(Collectors.joining(delimiter)));
    }

    @Override
    public void println() {
        this.print('\n');
    }

    @Override
    public void write(String s, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(off + i));
        }
    }

    @Override
    public void write(int c) {
        if (c == 10) {
            this.first = true;
        } else if (this.first) {
            this.first = false;
            for (int i = 0; i < this.indent * this.indentSize; ++i) {
                super.write(32);
            }
        }
        super.write(c);
    }

    @Override
    public CodeWriter append(CharSequence csq) {
        return (CodeWriter)super.append(csq);
    }

    @Override
    public CodeWriter append(CharSequence csq, int start, int end) {
        return (CodeWriter)super.append(csq, start, end);
    }

    @Override
    public CodeWriter append(char c) {
        return (CodeWriter)super.append(c);
    }

    @Override
    public CodeWriter format(String format, Object ... args) {
        return (CodeWriter)super.format(format, args);
    }

    @Override
    public CodeWriter format(Locale l, String format, Object ... args) {
        return (CodeWriter)super.format(l, format, args);
    }
}

