/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFinder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFinder.class);
    public static final String DATA_DIR = "data";

    public static CharBuffer readDataFileToCharBuffer(String basename) {
        return ResourceFinder.loadFileToCharBuffer(basename, DATA_DIR);
    }

    public static List<String> readDataFileLines(String basename) {
        return ResourceFinder.readFileLines(basename, DATA_DIR);
    }

    public static String readDataFileString(String basename) {
        return ResourceFinder.readFileString(basename, DATA_DIR);
    }

    public static InputStream findRequiredStreamOrFile(String basename, String extension, String ... searchPaths) {
        Optional<InputStream> optionalStreamOrFile = ResourceFinder.findOptionalStreamOrFile(basename, extension, searchPaths);
        return optionalStreamOrFile.orElseThrow(() -> new RuntimeException("Unable to find " + basename + " with extension " + extension + " in file system or in classpath, with search paths: " + Arrays.stream(searchPaths).collect(Collectors.joining(","))));
    }

    public static Reader findRequiredReader(String basename, String extension, String ... searchPaths) {
        Optional<Reader> optionalReader = ResourceFinder.findOptionalReader(basename, extension, searchPaths);
        return optionalReader.orElseThrow(() -> new RuntimeException("Unable to find " + basename + " with extension " + extension + " in file system or in classpath, with search paths: " + Arrays.stream(searchPaths).collect(Collectors.joining(","))));
    }

    public static Optional<Reader> findOptionalReader(String basename, String extenion, String ... searchPaths) {
        return ResourceFinder.findOptionalStreamOrFile(basename, extenion, searchPaths).map(InputStreamReader::new).map(BufferedReader::new);
    }

    public static Optional<InputStream> findOptionalStreamOrFile(final String basename, String extension, final String ... searchPaths) {
        boolean needsExtension = extension != null && !extension.isEmpty() && !basename.endsWith("." + extension);
        final String filename = basename + (String)(needsExtension ? "." + extension : "");
        ArrayList<String> paths = new ArrayList<String>(){
            {
                this.add(filename);
                if (!ResourceFinder.isRemote(basename)) {
                    this.addAll(Arrays.stream(searchPaths).map(s -> s + File.separator + filename).collect(Collectors.toCollection(ArrayList::new)));
                }
            }
        };
        for (String path : paths) {
            Optional<InputStream> stream = ResourceFinder.getInputStream(path);
            if (!stream.isPresent()) continue;
            return stream;
        }
        return Optional.empty();
    }

    private static boolean isRemote(String path) {
        return path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:");
    }

    public static Optional<InputStream> getInputStream(String path) {
        if (ResourceFinder.isRemote(path)) {
            try {
                URL url = new URL(path);
                InputStream inputStream = url.openStream();
                if (inputStream != null) {
                    return Optional.of(inputStream);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FileInputStream stream = new FileInputStream(path);
            return Optional.of(stream);
        }
        catch (FileNotFoundException stream) {
            ClassLoader classLoader = ResourceFinder.class.getClassLoader();
            InputStream stream2 = classLoader.getResourceAsStream(path);
            if (stream2 != null) {
                return Optional.of(stream2);
            }
            return Optional.empty();
        }
    }

    public static List<String> readFileLines(String basename, String ... searchPaths) {
        List<String> list;
        InputStream requiredStreamOrFile = ResourceFinder.findRequiredStreamOrFile(basename, "", DATA_DIR);
        BufferedReader buffer = new BufferedReader(new InputStreamReader(requiredStreamOrFile));
        try {
            List<String> collected;
            list = collected = buffer.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while reading required file to string", ioe);
            }
        }
        buffer.close();
        return list;
    }

    public static String readFileString(String basename, String ... searchPaths) {
        String string;
        InputStream requiredStreamOrFile = ResourceFinder.findRequiredStreamOrFile(basename, "", searchPaths);
        BufferedReader buffer = new BufferedReader(new InputStreamReader(requiredStreamOrFile));
        try {
            String filedata;
            string = filedata = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while reading required file to string", ioe);
            }
        }
        buffer.close();
        return string;
    }

    public static CSVParser readFileCSV(String basename, String ... searchPaths) {
        Reader reader = ResourceFinder.findRequiredReader(basename, "csv", searchPaths);
        CSVFormat format = CSVFormat.newFormat((char)',').withFirstRecordAsHeader();
        try {
            CSVParser parser = new CSVParser(reader, format);
            return parser;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CharBuffer loadFileToCharBuffer(String filename, String ... searchPaths) {
        CharBuffer linesImage;
        InputStream stream = ResourceFinder.findRequiredStreamOrFile(filename, "", searchPaths);
        try {
            InputStreamReader isr = new InputStreamReader(stream);
            linesImage = CharBuffer.allocate(0x100000);
            while (isr.read(linesImage) > 0) {
            }
            isr.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        linesImage.flip();
        return linesImage.asReadOnlyBuffer();
    }
}

