/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.sqlserver;

import is.codion.common.db.database.AbstractDatabase;
import java.sql.SQLException;
import java.util.Objects;

final class SQLServerDatabase
extends AbstractDatabase {
    static final String AUTO_INCREMENT_QUERY = "SELECT @@IDENTITY";
    private static final int AUTHENTICATION_ERROR = 18456;
    private static final int REFERENTIAL_INTEGRITY_ERROR = 547;
    private static final int UNIQUE_CONSTRAINT_ERROR1 = 2601;
    private static final int UNIQUE_CONSTRAINT_ERROR2 = 2627;
    private static final String JDBC_URL_PREFIX = "jdbc:sqlserver://";

    SQLServerDatabase(String url) {
        super(url);
    }

    public String name() {
        String name = SQLServerDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX});
        if (name.contains("\\") && (name = name.substring(name.lastIndexOf(92) + 1)).contains(":")) {
            name = name.substring(0, name.indexOf(58));
        }
        return name;
    }

    public String selectForUpdateClause() {
        return "";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return SQLServerDatabase.createOffsetFetchNextClause((Integer)limit, (Integer)offset);
    }

    public boolean subqueryRequiresAlias() {
        return true;
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY;
    }

    public boolean isAuthenticationException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 18456;
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 547;
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 2601 || exception.getErrorCode() == 2627;
    }
}

