/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DisposableDataSource;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.SequenceNameConverter;
import net.java.ao.schema.TriggerNameConverter;
import net.java.ao.schema.UniqueNameConverter;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;
import net.java.ao.util.StringUtils;

public final class PostgreSQLDatabaseProvider
extends DatabaseProvider {
    private static final int MAX_SEQUENCE_LENGTH = 64;
    private static final String SQL_STATE_UNDEFINED_FUNCTION = "42883";
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object[])new String[]{"ABS", "ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BIT_LENGTH", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CALLED", "CARDINALITY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CEIL", "CEILING", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLASS", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLLECT", "COLUMN", "COMMIT", "COMPLETION", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "CONVERT", "CORR", "CORRESPONDING", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DENSE_RANK", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTICS", "DICTIONARY", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "END", "END-EXEC", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXP", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST", "FLOAT", "FLOOR", "FOR", "FOREIGN", "FOUND", "FREE", "FREEZE", "FROM", "FULL", "FUNCTION", "FUSION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GREATEST", "GROUP", "GROUPING", "HAVING", "HOLD", "HOST", "HOUR", "IDENTITY", "IGNORE", "ILIKE", "IMMEDIATE", "IN", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "IS", "ISNULL", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEAST", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LN", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOWER", "MAP", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MOD", "MODIFIES", "MODIFY", "MODULE", "MONTH", "MULTISET", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NORMALIZE", "NOT", "NOTNULL", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OCTET_LENGTH", "OF", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "OVERLAY", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PARTITION", "PATH", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "PLACING", "POSITION", "POSTFIX", "POWER", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "RANGE", "RANK", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELATIVE", "RELEASE", "RESTRICT", "RESULT", "RETURN", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "ROW_NUMBER", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SENSITIVE", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETOF", "SETS", "SIMILAR", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQRT", "START", "STATE", "STATEMENT", "STATIC", "STDDEV_POP", "STDDEV_SAMP", "STRUCTURE", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEMPORARY", "TERMINATE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UESCAPE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VAR_POP", "VAR_SAMP", "VERBOSE", "VIEW", "WHEN", "WHENEVER", "WHERE", "WIDTH_BUCKET", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"});

    public PostgreSQLDatabaseProvider(DisposableDataSource dataSource) {
        this(dataSource, "public");
    }

    public PostgreSQLDatabaseProvider(DisposableDataSource dataSource, String schema) {
        super(dataSource, schema, TypeManager.postgres());
    }

    @Override
    public Object parseValue(int type, String value) {
        if (value == null || value.equals("") || value.equals("NULL")) {
            return null;
        }
        switch (type) {
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                Matcher matcher = Pattern.compile("'(.*)'.*").matcher(value);
                if (!matcher.find()) break;
                value = matcher.group(1);
                break;
            }
            case -7: {
                try {
                    return Byte.parseByte(value);
                }
                catch (Throwable t) {
                    try {
                        return Boolean.parseBoolean(value);
                    }
                    catch (Throwable t1) {
                        return null;
                    }
                }
            }
        }
        return super.parseValue(type, value);
    }

    @Override
    public ResultSet getTables(Connection conn) throws SQLException {
        return conn.getMetaData().getTables(null, this.getSchema(), null, new String[]{"TABLE"});
    }

    @Override
    protected String renderAutoIncrement() {
        return "";
    }

    @Override
    protected String renderFieldType(DDLField field) {
        if (field.getJdbcType() == 2) {
            field.setType(this.typeManager.getType(Integer.class));
        }
        if (field.isAutoIncrement()) {
            if (field.getJdbcType() == -5) {
                return "BIGSERIAL";
            }
            return "SERIAL";
        }
        return super.renderFieldType(field);
    }

    @Override
    protected String renderValue(Object value) {
        if (value instanceof Boolean) {
            if (value.equals(true)) {
                return "TRUE";
            }
            return "FALSE";
        }
        return super.renderValue(value);
    }

    @Override
    protected String renderUnique(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        return "CONSTRAINT " + uniqueNameConverter.getName(table.getName(), field.getName()) + " UNIQUE";
    }

    @Override
    public Object handleBlob(ResultSet res, Class<?> type, String field) throws SQLException {
        if (type.equals(InputStream.class)) {
            return res.getBinaryStream(field);
        }
        if (type.equals(byte[].class)) {
            return res.getBytes(field);
        }
        return null;
    }

    @Override
    protected List<String> renderAlterTableChangeColumn(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field) {
        String toRender;
        StringBuilder str;
        String function;
        TriggerNameConverter triggerNameConverter = nameConverters.getTriggerNameConverter();
        SequenceNameConverter sequenceNameConverter = nameConverters.getSequenceNameConverter();
        UniqueNameConverter uniqueNameConverter = nameConverters.getUniqueNameConverter();
        ArrayList<String> back = new ArrayList<String>();
        String trigger = this.getTriggerNameForField(triggerNameConverter, table, oldField);
        if (trigger != null) {
            StringBuilder str2 = new StringBuilder();
            str2.append("DROP TRIGGER ").append(this.processID(trigger));
            back.add(str2.toString());
        }
        if ((function = this.getFunctionNameForField(triggerNameConverter, table, oldField)) != null) {
            StringBuilder str3 = new StringBuilder();
            str3.append("DROP FUNCTION IF EXISTS ").append(this.withSchema(function));
            back.add(str3.toString());
        }
        if (!field.isUnique() && oldField.isUnique()) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " DROP CONSTRAINT " + uniqueNameConverter.getName(table.getName(), field.getName()));
        }
        if (field.isUnique() && !oldField.isUnique()) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " ADD CONSTRAINT " + uniqueNameConverter.getName(table.getName(), field.getName()) + " UNIQUE (" + this.processID(field.getName()) + ")");
        }
        boolean foundChange = false;
        if (!field.getName().equalsIgnoreCase(oldField.getName())) {
            foundChange = true;
            str = new StringBuilder();
            str.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" RENAME COLUMN ");
            str.append(this.processID(oldField.getName())).append(" TO ").append(this.processID(field.getName()));
            back.add(str.toString());
        }
        if (!field.getType().equals(oldField.getType())) {
            foundChange = true;
            str = new StringBuilder();
            str.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ALTER COLUMN ");
            str.append(this.processID(field.getName())).append(" TYPE ");
            str.append(this.renderFieldType(field));
            back.add(str.toString());
        }
        if (field.getDefaultValue() != null || oldField.getDefaultValue() != null) {
            if (field.getDefaultValue() == null && oldField.getDefaultValue() != null) {
                foundChange = true;
                str = new StringBuilder();
                str.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ALTER COLUMN ");
                str.append(this.processID(field.getName())).append(" DROP DEFAULT");
                back.add(str.toString());
            } else if (!field.getDefaultValue().equals(oldField.getDefaultValue())) {
                foundChange = true;
                str = new StringBuilder();
                str.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ALTER COLUMN ");
                str.append(this.processID(field.getName())).append(" SET DEFAULT ").append(this.renderValue(field.getDefaultValue()));
                back.add(str.toString());
            }
        }
        if (field.isNotNull() != oldField.isNotNull()) {
            foundChange = true;
            if (field.isNotNull()) {
                str = new StringBuilder();
                str.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ALTER COLUMN ");
                str.append(this.processID(field.getName())).append(" SET NOT NULL");
                back.add(str.toString());
            } else {
                str = new StringBuilder();
                str.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ALTER COLUMN ");
                str.append(this.processID(field.getName())).append(" DROP NOT NULL");
                back.add(str.toString());
            }
        }
        if (!foundChange) {
            System.err.println("WARNING: PostgreSQL doesn't fully support CHANGE TABLE statements");
            System.err.println("WARNING: Data contained in column '" + table.getName() + "." + oldField.getName() + "' will be lost");
            back.addAll(Arrays.asList(this.renderAlterTableDropColumn(triggerNameConverter, table, oldField)));
            back.addAll(this.renderAlterTableAddColumn(nameConverters, table, field));
        }
        if ((toRender = this.renderFunctionForField(triggerNameConverter, table, field)) != null) {
            back.add(toRender);
        }
        if ((toRender = this.renderTriggerForField(triggerNameConverter, sequenceNameConverter, table, field)) != null) {
            back.add(toRender);
        }
        return back;
    }

    @Override
    protected String renderAlterTableDropKey(DDLForeignKey key) {
        StringBuilder back = new StringBuilder("ALTER TABLE ");
        back.append(this.withSchema(key.getDomesticTable())).append(" DROP CONSTRAINT ").append(this.processID(key.getFKName()));
        return back.toString();
    }

    @Override
    protected String renderDropIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        return "DROP INDEX " + this.withSchema(indexNameConverter.getName(this.shorten(index.getTable()), this.shorten(index.getField())));
    }

    @Override
    protected String[] renderDropFunctions(TriggerNameConverter triggerNameConverter, DDLTable table) {
        ArrayList<String> dropFunctions = new ArrayList<String>();
        for (DDLField field : table.getFields()) {
            String function = this.renderDropFunction(this.getFunctionNameForField(triggerNameConverter, table, field));
            if (StringUtils.isBlank(function)) continue;
            dropFunctions.add(function);
        }
        return dropFunctions.toArray(new String[dropFunctions.size()]);
    }

    private String renderDropFunction(String functionName) {
        if (!StringUtils.isBlank(functionName)) {
            return "DROP FUNCTION IF EXISTS " + (this.isSchemaNotEmpty() ? this.getSchema() + "." + functionName : functionName) + " CASCADE";
        }
        return null;
    }

    @Override
    public synchronized <T extends RawEntity<K>, K> K insertReturningKey(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, boolean pkIdentity, String table, DBParam ... params) throws SQLException {
        Object back = null;
        for (DBParam param : params) {
            if (!param.getField().trim().equalsIgnoreCase(pkField)) continue;
            back = param.getValue();
            break;
        }
        if (back == null) {
            String sql = "SELECT NEXTVAL('" + this.processID(this.sequenceName(pkField, table)) + "')";
            PreparedStatement stmt = this.preparedStatement(conn, sql);
            ResultSet res = stmt.executeQuery();
            if (res.next()) {
                back = this.typeManager.getType(pkType).getLogicalType().pullFromDatabase(null, res, pkType, 1);
            }
            res.close();
            stmt.close();
            ArrayList<DBParam> newParams = new ArrayList<DBParam>();
            newParams.addAll(Arrays.asList(params));
            newParams.add(new DBParam(pkField, back));
            params = newParams.toArray(new DBParam[newParams.size()]);
        }
        super.insertReturningKey(manager, conn, entityType, pkType, pkField, pkIdentity, table, params);
        return (K)back;
    }

    private String sequenceName(String pkField, String table) {
        String suffix = "_" + pkField + "_seq";
        int tableLength = table.length();
        int theoreticalLength = tableLength + suffix.length();
        if (theoreticalLength > 64) {
            int extraCharacters = theoreticalLength - 64;
            return table.substring(0, tableLength - extraCharacters - 1) + suffix;
        }
        return table + suffix;
    }

    @Override
    protected <T extends RawEntity<K>, K> K executeInsertReturningKey(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, String sql, DBParam ... params) throws SQLException {
        PreparedStatement stmt = this.preparedStatement(conn, sql);
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i].getValue();
            if (value instanceof RawEntity) {
                value = Common.getPrimaryKeyValue((RawEntity)value);
            }
            if (value == null) {
                this.putNull(stmt, i + 1);
                continue;
            }
            TypeInfo<?> type = this.typeManager.getType(value.getClass());
            type.getLogicalType().putToDatabase(manager, stmt, i + 1, value, type.getJdbcWriteType());
        }
        stmt.executeUpdate();
        stmt.close();
        return null;
    }

    @Override
    protected Set<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    protected boolean shouldQuoteID(String id) {
        return !"*".equals(id);
    }

    @Override
    public void handleUpdateError(String sql, SQLException e) throws SQLException {
        if (e.getSQLState().equals(SQL_STATE_UNDEFINED_FUNCTION) && e.getMessage().contains("does not exist")) {
            this.logger.debug("Ignoring SQL exception for <" + sql + ">", (Throwable)e);
            return;
        }
        super.handleUpdateError(sql, e);
    }
}

