/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.benchmark.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.java.ao.benchmark.util.Report;

public final class StopWatch<K> {
    private final SortedMap<K, Long> laps = new TreeMap<K, Long>();
    private final String name;
    private long start;
    private long stop;
    private long lap;

    public StopWatch(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        this.lap = this.start = this.now();
        this.laps.clear();
    }

    public void lap(K k) {
        long now = this.now();
        this.laps.put(k, now - this.lap);
        this.lap = now;
    }

    public void stop() {
        this.stop = this.now();
    }

    private long now() {
        return System.nanoTime();
    }

    private boolean isStopped() {
        return this.stop > 0L;
    }

    public Report getReport() {
        if (!this.isStopped()) {
            throw new IllegalStateException("Stop watch must be stopped to generate report");
        }
        return new Report(this.name, this.start, this.stop, this.laps());
    }

    private List<Long> laps() {
        ArrayList<Long> lapValues = new ArrayList<Long>(this.laps.size());
        for (Map.Entry<K, Long> e : this.laps.entrySet()) {
            lapValues.add(e.getValue());
        }
        return lapValues;
    }

    public void printResults(boolean printLaps) {
        System.out.printf("%s:\n", this.name);
        System.out.printf("\tTotal time: %sms\n", StopWatch.convertToMillis(this.stop - this.start));
        if (!this.laps.isEmpty()) {
            System.out.printf("\tAverage time: %sms\n", StopWatch.convertToMillis((this.stop - this.start) / (long)this.laps.size()));
        }
        if (printLaps) {
            System.out.println("\tLaps:");
            for (Map.Entry<K, Long> lap : this.laps.entrySet()) {
                System.out.printf("\t\t%s : %sms\n", lap.getKey(), StopWatch.convertToMillis(lap.getValue().longValue()));
            }
        }
    }

    private static double convertToMillis(double valueInNano) {
        return valueInNano / 1000000.0;
    }
}

