/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.benchmark.util;

import java.util.List;

public final class Report {
    private String name;
    private long start;
    private long stop;
    private List<Long> laps;

    public Report(String name, long start, long stop, List<Long> laps) {
        this.name = name;
        this.start = start;
        this.stop = stop;
        this.laps = laps;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLaps() {
        return !this.laps.isEmpty();
    }

    public double getAverageTime() {
        if (!this.hasLaps()) {
            throw new IllegalStateException("Cannot calculate average with no laps");
        }
        return Report.convertToMillis((this.stop - this.start) / (long)this.laps.size());
    }

    public double getTotalTime() {
        return Report.convertToMillis(this.stop - this.start);
    }

    private static double convertToMillis(double valueInNano) {
        return valueInNano / 1000000.0;
    }
}

