/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder.proxool;

import java.sql.Driver;
import javax.sql.DataSource;
import net.java.ao.DisposableDataSource;
import net.java.ao.builder.ClassUtils;
import net.java.ao.builder.DataSourceFactory;
import net.java.ao.builder.DelegatingDisposableDataSource;
import org.logicalcobwebs.proxool.ProxoolDataSource;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxoolDataSourceFactory
implements DataSourceFactory {
    private static final String ALIAS = "active-objects";

    @Override
    public DisposableDataSource getDataSource(Class<? extends Driver> driverClass, String url, String username, String password) {
        ProxoolDataSource source = new ProxoolDataSource(ALIAS);
        source.setUser(username);
        source.setPassword(password);
        source.setDriver(driverClass.getName());
        source.setDriverUrl(url);
        source.setMaximumConnectionCount(30);
        return new DelegatingDisposableDataSource((DataSource)source){

            public void dispose() {
                try {
                    ProxoolFacade.removeConnectionPool((String)ProxoolDataSourceFactory.ALIAS);
                }
                catch (ProxoolException proxoolException) {
                    // empty catch block
                }
            }
        };
    }

    public static boolean isAvailable() {
        return ClassUtils.loadClass("org.logicalcobwebs.proxool.ProxoolDriver") != null;
    }
}

