/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.tx;

import java.sql.Connection;
import java.sql.SQLException;
import net.java.ao.DelegateConnection;
import net.java.ao.EntityManager;
import net.java.ao.test.tx.TransactionException;

public final class Transaction {
    private final EntityManager entityManager;
    private Connection connection = null;

    public Transaction(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void start() {
        try {
            this.connection = this.entityManager.getProvider().getConnection();
            this.setCloseable(this.connection, false);
            this.connection.setTransactionIsolation(8);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    public void rollback() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
                this.setCloseable(this.connection, true);
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    private void setCloseable(Connection connection, boolean closeable) {
        if (connection instanceof DelegateConnection) {
            ((DelegateConnection)connection).setCloseable(closeable);
        }
    }
}

