/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.impl.javaee;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import net.java.trueupdate.agent.impl.javaee.UpdateAgentMessageDispatcherBean;
import net.java.trueupdate.manager.spec.UpdateMessage;

@MessageDriven(mappedName="jms/TrueUpdate Agent", activationConfig={@ActivationConfigProperty(propertyName="messageSelector", propertyValue="manager = false")})
@DependsOn(value={"UpdateAgentMessageDispatcherBean"})
public class UpdateAgentMessageListenerBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(UpdateAgentMessageListenerBean.class.getName());
    @EJB
    private UpdateAgentMessageDispatcherBean updateAgentMessageDispatcher;
    @Resource
    private MessageDrivenContext context;

    public void onMessage(Message message) {
        logger.log(Level.FINEST, "Received JMS message for update agent: {0}", message);
        try {
            Serializable body;
            if (message instanceof ObjectMessage && (body = ((ObjectMessage)message).getObject()) instanceof UpdateMessage) {
                this.updateAgentMessageDispatcher.onUpdateMessage((UpdateMessage)body);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.context.setRollbackOnly();
            logger.log(Level.SEVERE, "Could not process JMS message.", ex);
        }
    }
}

