package net.polyv.group.v1.constant;

/**
 * @author: sadboy
 **/
public class GroupURL {
    
    private static boolean isHttps = true;
    
    /**
     * POLYV group api base uri
     */
    private static final String BASE_URI = "api.polyv.net/live/";
    
    /**
     * 设置自定义域名
     */
    private static String customUri = "";
    
    /**
     * url 替换通配符
     */
    private static final String PARAM_REPLACE_CHAR = "%s";
    
    /**
     * 集团账号查询主账号账单
     */
    public static final String GROUP_LIST_BILLING_URL = BASE_URI + "v4/group/account/billing-daily/list";
    
    /**
     * 集团账号查询分账号列表及分账号剩余资源
     */
    public static final String GROUP_LIST_PACKAGE_URL = BASE_URI + "v4/group/user/package/list";
    
    /**
     * 创建集团分帐号
     */
    public static final String GROUP_CREATE_URL = BASE_URI + "v4/group/user/create";
    
    /**
     * 分配分帐号资源
     */
    public static final String GROUP_UPDATE_PACKAGE_URL = BASE_URI + "v4/group/user/package/update";
    
    /**
     * 获取替换参数后的URL地址
     * @param format 格式化
     * @param param 格式参数
     * @return 格式化后字符串
     */
    public static String getRealUrl(String format, Object... param) {
        return String.format(format, param);
    }
    
    public static boolean getIsHttps(){
        return isHttps;
    }
    
    /**
     * 设置直播API协议为http
     */
    public static void setLiveHttpProtocol(){
        isHttps = false;
    }
    
    /**
     * 设置直播API协议为https
     */
    public static void setLiveHttpsProtocol(){
        isHttps = true;
    }
    
    public static String getCustomUri() {
        return customUri;
    }
    
    /**
     * 设置自定义域名
     */
    public static void setCustomUri(String customUri) {
        GroupURL.customUri = customUri;
    }
    
}
