package net.polyv.group.v1.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.entity.CommonReqeust;
import net.polyv.common.v1.validator.constraints.NotBlank;

/**
 * 集团账号公共请求实体
 * @author: sadboy
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class GroupCommonRequest extends CommonReqeust {
    
    /**
     * POLYV集团账号用户APP_ID，通过登录集团账号后台获取，路径：集团账号后台(group.polyv.net)->登录->我的资料
     */
    @ApiModelProperty(hidden = true, required = true)
    @NotBlank(message = "属性appId不能为空")
    private String appId;
    /**
     * 请求发送当时的时间戳（ms)，系统自动生成
     */
    @ApiModelProperty(hidden = true, required = true)
    @NotBlank(message = "属性timestamp不能为空")
    private String timestamp;
    /**
     * 数据MD5签名，系统自动生成
     */
    @ApiModelProperty(hidden = true, required = true)
    @NotBlank(message = "属性sign不能为空")
    private String sign;
    
    /**
     * 每次请求的业务流水号，便于客户端/服务器端排查问题
     */
    @ApiModelProperty(hidden = true, required = true)
    @NotBlank(message = "属性requestId不能为空")
    private String requestId;
    
}
