package net.polyv.group.v1.entity;

import java.util.List;

import com.alibaba.fastjson.JSON;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 集团账号公共返回数据实体
 * @author: sadboy
 **/
@Data
@Accessors(chain = true)
public class GroupCommonResponse {
    
    /**
     * 响应码
     */
    protected int code;
    
    
    /**
     * 请求状态
     */
    protected String status;
    
    /**
     * 返回的requestId
     */
    protected String requestId;
    
    /**
     * 错误信息
     */
    protected String message;
    
    /**
     * 实际返回数据
     */
    protected String data;
    
    /**
     * 请求是否成功
     */
    protected Boolean success;
    
    /**
     * 错误信息
     */
    protected Error error;
    
    
    public <T> T parseData(Class<T> dataClass) {
        if (dataClass == String.class) {
            return (T) this.data;
        }
        return JSON.parseObject(this.data, dataClass);
    }
    
    public  <T> List<T> parseArray(Class<T> dataClass) {
        return JSON.parseArray(this.data, dataClass);
        
    }
    
    
    /**
     * 判断请求是否成功
     * @return true/false
     */
    public boolean isRequestOk() {
        return 200 == this.code;
    }
    
    /**
     * 错误返回
     */
    @Data
    @Accessors(chain = true)
    public static class Error{
        
        /**
         * 错误码
         */
        private int code;
        
        /**
         * 错误描述
         */
        private String desc;
        
    }
    
}
