package net.polyv.group.v1.entity.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.group.v1.entity.GroupCommonRequest;

/**
 * 查询分账号列表及剩余资源请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询分账号列表及剩余资源请求实体")
public class GroupListPackageRequest extends GroupCommonRequest {
    /**
     * 分账号邮箱，多个用英文逗号分隔，最多100个
     */
    @ApiModelProperty(name = "emails", value = "分账号邮箱，多个用英文逗号分隔，最多100个", required = false)
    private String emails;
    
    /**
     * 每页数据大小，默认10，最大值100
     */
    @ApiModelProperty(name = "pageSize", value = "每页数据大小，默认10，最大值100", required = false)
    private Integer pageSize;
    
    /**
     * 当前的页数，默认1
     */
    @ApiModelProperty(name = "pageNumber", value = "当前的页数，默认1", required = false)
    private Integer pageNumber;
    
}