package net.polyv.vclass.v1.entity.file;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.vclass.v1.entity.VClassPageCommonResponse;

/**
 * 查询课节已上传文档列表响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询课节已上传文档列表响应实体")
public class VClassDocListResponse extends VClassPageCommonResponse {
    
    
    @ApiModelProperty(name = "contents", value = "文档列表", required = false)
    private List<Doc> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("频道文档")
    public static class Doc {
        
        /**
         * 文件ID
         */
        @ApiModelProperty(name = "fileId", value = "文件ID", required = false)
        private String fileId;
        
        /**
         * 文件名
         */
        @ApiModelProperty(name = "fileName", value = "文件名", required = false)
        private String fileName;
        
        /**
         * 文件url
         */
        @ApiModelProperty(name = "fileUrl", value = "文件url", required = false)
        private String fileUrl;
        
        /**
         * 文件类型
         */
        @ApiModelProperty(name = "fileType", value = "文件类型", required = false)
        private String fileType;
        
        /**
         * 上传文档的内容的总页数
         */
        @ApiModelProperty(name = "totalPage", value = "上传文档的内容的总页数", required = false)
        private Integer totalPage;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 文档状态，不传默认查询所有 normal：正常 waitUpload：等待上传 failUpload：上传失败 waitConvert：转换PPT中 failConvert：转换PPT失败
         */
        @ApiModelProperty(name = "status", value = "文档状态，不传默认查询所有 normal：正常 waitUpload：等待上传 failUpload：上传失败 " +
                "waitConvert：转换PPT中 failConvert：转换PPT失败", required = false)
        private String status;
        
        /**
         * 创建时间
         */
        @ApiModelProperty(name = "createTime", value = "创建时间", required = false)
        private Date createTime;
        
        /**
         * 转换类型，默认不传转普通，因为只有ppt，pptx可以转动画，其他类型文件会自动转成普通；文件转动画转失败会直接把类型转为普通 common：转普通图片 animate：转动画效果
         */
        @ApiModelProperty(name = "convertType", value =
                "转换类型，默认不传转普通，因为只有ppt，pptx可以转动画，其他类型文件会自动转成普通；文件转动画转失败会直接把类型转为普通 " +
                        "common：转普通图片 animate：转动画效果", required = false)
        private String convertType;
        
        /**
         * ppt预览小图地址
         */
        @ApiModelProperty(name = "previewImage", value = "ppt预览小图地址", required = false)
        private String previewImage;
        
        /**
         * ppt预览大图地址
         */
        @ApiModelProperty(name = "previewBigImage", value = "ppt预览大图地址", required = false)
        private String previewBigImage;
        
        /**
         * 文档ID
         */
        @ApiModelProperty(name = "autoId", value = "文档ID", required = false)
        private Integer autoId;
    }
}