package net.polyv.vclass.v1.entity.file;

import java.io.File;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassCommonRequest;

/**
 * 上传文档到某个课节请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("上传文档到某个课节请求实体")
public class VClassUploadDocRequest extends VClassCommonRequest {
    
    /**
     * 课节号
     */
    @ApiModelProperty(name = "lessonId", value = "课节号", required = true)
    @NotNull(message = "属性lessonId不能为空")
    private Long lessonId;
    
    /**
     * 上传的文件不超过50M，格式限制为（ppt， pdf，pptx，doc，docx，wps，xls，xlsx），file和url只需要传递其中一个，如果传递了url和file，以file字段为准
     */
    @ApiModelProperty(name = "file", value = "上传的文件不超过50M，格式限制为（ppt， pdf，pptx，doc，docx，wps，xls，xlsx），file和url" +
            "只需要传递其中一个，如果传递了url和file，以file字段为准", required = false)
    private File file;
    
    /**
     * 转换类型，默认不传转普通，因为只有ppt，pptx可以转动画，其他类型文件会自动转成普通；文件转动画转失败会直接把类型转为普通 common：转普通图片 animate：转动画效果
     */
    @ApiModelProperty(name = "type", value = "转换类型，默认不传转普通，因为只有ppt，pptx可以转动画，其他类型文件会自动转成普通；文件转动画转失败会直接把类型转为普通 " +
            "common：转普通图片 animate：转动画效果", required = false)
    private String type;
    
    /**
     * 文档名称，默认不传使用ppt上传的文件获取到的文件名作为文档名称，文档名称不得超过100个字符
     */
    @ApiModelProperty(name = "docName", value = "文档名称，默认不传使用ppt上传的文件获取到的文件名作为文档名称，文档名称不得超过100个字符", required = false)
    private String docName;
    
    /**
     * 文档上传转换成功回调地址
     */
    @ApiModelProperty(name = "callbackUrl", value = "文档上传转换成功回调地址", required = false)
    private String callbackUrl;
    
    /**
     * 文件地址url（需要可访问的地址），file和url只需要传递其中一个，如果传递了url和file，以file字段为准
     */
    @ApiModelProperty(name = "url", value = "文件地址url（需要可访问的地址），file和url只需要传递其中一个，如果传递了url和file，以file字段为准", required =
            false)
    private String url;
    
}