package net.polyv.vclass.v1.entity.file;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 上传文档到某个课节响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("上传文档到某个课节响应实体")
public class VClassUploadDocResponse {
    
    /**
     * 转换类型，默认不传转普通，因为只有ppt，pptx可以转动画，其他类型文件会自动转成普通；文件转动画转失败会直接把类型转为普通 common：转普通图片 animate：转动画效果
     */
    @ApiModelProperty(name = "type", value = "转换类型，默认不传转普通，因为只有ppt，pptx可以转动画，其他类型文件会自动转成普通；文件转动画转失败会直接把类型转为普通 " +
            "common：转普通图片 animate：转动画效果", required = false)
    private String type;
    
    /**
     * 文件ID，成功时返回
     */
    @ApiModelProperty(name = "fileId", value = "文件ID，成功时返回", required = false)
    private String fileId;
    
    /**
     * 文档状态 normal：正常 waitUpload：等待上传 failUpload：上传失败 waitConvert：转换PPT中 failConvert：转换PPT失败
     */
    @ApiModelProperty(name = "status", value = "文档状态 normal：正常 waitUpload：等待上传 failUpload：上传失败 waitConvert：转换PPT中 " +
            "failConvert：转换PPT失败", required = false)
    private String status;
    
}