package net.polyv.vclass.v1.entity.lesson;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassCommonRequest;

/**
 * 查询课节实时状态和在线人数请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询课节实时状态和在线人数请求实体")
public class VClassGetLessonLiveInfoRequest extends VClassCommonRequest {
    
    /**
     * 课节号，以逗号分隔（上限100个课节） 例如：1015,1016
     */
    @ApiModelProperty(name = "lessonIds", value = "课节号，以逗号分隔（上限100个课节） 例如：1015,1016", required = true)
    @NotNull(message = "属性lessonIds不能为空")
    private String lessonIds;
    
}